/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.remote;

import de.is24.common.hateoas.HateoasLinkProvider;
import de.is24.common.hystrix.HystrixConfiguration;
import de.is24.common.togglz.remote.FeatureSwitchRemoteClient;
import de.is24.common.togglz.remote.api.RemoteFeatureState;
import de.is24.common.togglz.remote.command.GetRemoteFeatureStatesCommand;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.hateoas.Resources;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestOperations;
import org.togglz.core.repository.FeatureState;

@Service
public class RemoteFeatureStatesClient
extends FeatureSwitchRemoteClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteFeatureStatesClient.class);
    @Autowired
    private HystrixConfiguration hystrixConfiguration;

    public RemoteFeatureStatesClient(RestOperations restOperations, HateoasLinkProvider hateoasLinkProvider, String remoteServiceBaseUri) {
        super(restOperations, hateoasLinkProvider, remoteServiceBaseUri);
    }

    @Cacheable(value={"remoteFeatureStates"})
    public List<FeatureState> getRemoteFeatureStates() {
        LOGGER.info("Retrieving latest FeatureStates from remote service.");
        Resources remoteFeatureStateResources = (Resources)new GetRemoteFeatureStatesCommand(this.hystrixConfiguration, this.restOperations, this.featureSwitchHateoasLinkProvider, this.remoteServiceBaseUri).execute();
        ArrayList<FeatureState> featureStates = new ArrayList<FeatureState>();
        remoteFeatureStateResources.forEach(r -> {
            RemoteFeatureState remoteFeatureState = (RemoteFeatureState)r.getContent();
            featureStates.add(RemoteFeatureState.toFeatureState(remoteFeatureState));
        });
        return featureStates;
    }
}

