/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.filter.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class BufferingResponseWrapper
extends HttpServletResponseWrapper {
    private final HttpServletResponse wrappedResponse;
    private final ByteBufferStream buf = new ByteBufferStream();
    private final PrintWriter writer = new PrintWriter((OutputStream)((Object)this.buf));
    private String location;

    public BufferingResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.wrappedResponse = httpServletResponse;
        this.wrappedResponse.setBufferSize(Integer.MAX_VALUE);
    }

    public void addCookie(Cookie cookie) {
        super.addCookie(cookie);
    }

    public void sendRedirect(String location) {
        this.location = location;
    }

    public ServletOutputStream getOutputStream() {
        return this.buf;
    }

    public boolean isCommitted() {
        return false;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void flushBuffer() {
    }

    public void send() throws IOException {
        this.writer.flush();
        if (this.location != null) {
            this.wrappedResponse.sendRedirect(this.location);
        }
        this.wrappedResponse.getOutputStream().write(this.buf.getBytes());
    }

    private final class ByteBufferStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        private ByteBufferStream() {
        }

        public void write(int b) {
            this.buffer.write(b);
        }

        public byte[] getBytes() {
            return this.buffer.toByteArray();
        }
    }
}

