/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.filter;

import de.is24.common.togglz.filter.cookie.CookieHandler;
import de.is24.common.togglz.filter.wrapper.BufferingResponseWrapper;
import de.is24.common.togglz.repository.ThreadLocalStateRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.FeatureProvider;

public class TogglzCookieStateRepositoryFilter
extends ThreadLocalStateRepository
implements Filter {
    String togglzEditPagePath = "/internal/togglz/edit";
    private final FeatureProvider featureProvider;
    private final CookieHandler cookieHandler;

    public TogglzCookieStateRepositoryFilter(FeatureProvider featureProvider, CookieHandler cookieHandler) {
        this.featureProvider = featureProvider;
        this.cookieHandler = cookieHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        this.setModificationState(false);
        this.setThreadLocalFeatureMap(this.buildFeatureMapFromRequest(httpRequest));
        try {
            if (this.isTogglzPostRequest(httpRequest)) {
                this.handleTogglzPostRequest(servletRequest, servletResponse, filterChain);
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        }
        finally {
            this.resetThreadLocals();
        }
    }

    private boolean isTogglzPostRequest(HttpServletRequest servletRequest) {
        return "POST".equalsIgnoreCase(servletRequest.getMethod()) && servletRequest.getRequestURI().endsWith(this.togglzEditPagePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTogglzPostRequest(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        BufferingResponseWrapper wrapper = new BufferingResponseWrapper((HttpServletResponse)servletResponse);
        try {
            filterChain.doFilter(servletRequest, (ServletResponse)wrapper);
        }
        finally {
            if (this.getModificationState().booleanValue()) {
                this.safeFeatureMapToCookie(this.getThreadLocalFeatureMap(), (HttpServletResponse)wrapper);
            }
            wrapper.send();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public String getTogglzEditPagePath() {
        return this.togglzEditPagePath;
    }

    public void setTogglzEditPagePath(String togglzEditPagePath) {
        this.togglzEditPagePath = togglzEditPagePath;
    }

    private Map<String, FeatureState> buildFeatureMapFromRequest(HttpServletRequest request) {
        String cookiePayload = this.cookieHandler.retrieveCookiePayload(request);
        Map<String, FeatureState> featureMap = null;
        if (!cookiePayload.isEmpty()) {
            featureMap = this.deserializeFeatureMap(cookiePayload);
        }
        if (featureMap == null) {
            featureMap = new HashMap<String, FeatureState>();
        }
        return featureMap;
    }

    private String serializeFeatureMap(Map<String, FeatureState> map) {
        ArrayList features = new ArrayList();
        map.forEach((f, s) -> features.add(f + "=" + s.isEnabled()));
        return StringUtils.join(features, (String)",");
    }

    private Map<String, FeatureState> deserializeFeatureMap(String value) {
        String[] split = value.split(",");
        HashMap<String, FeatureState> map = new HashMap<String, FeatureState>();
        for (int i = 0; i < split.length; ++i) {
            String featureState = split[i];
            String[] featureStateParts = featureState.split("=");
            String featureName = featureStateParts[0];
            boolean enabled = Boolean.valueOf(featureStateParts[1]);
            Optional<Feature> feature = this.findFeatureByName(featureName);
            if (!feature.isPresent()) continue;
            Feature f = feature.get();
            map.put(f.name(), new FeatureState(f, enabled));
        }
        return map;
    }

    private Optional<Feature> findFeatureByName(String name) {
        Set features = this.featureProvider.getFeatures();
        return features.stream().filter(f -> name.equals(f.name())).findFirst();
    }

    private void safeFeatureMapToCookie(Map<String, FeatureState> featureMap, HttpServletResponse response) {
        String cookiePayload = this.serializeFeatureMap(featureMap);
        this.cookieHandler.savePayloadToCookie(cookiePayload, response);
    }
}

