/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.repository;

import java.util.HashMap;
import java.util.Map;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class ThreadLocalStateRepository
implements StateRepository {
    private final ThreadLocal<Map<String, FeatureState>> threadLocalFeatureMap = new InheritableThreadLocal<Map<String, FeatureState>>();
    private final ThreadLocal<Boolean> modificationState = new InheritableThreadLocal<Boolean>();

    public FeatureState getFeatureState(Feature feature) {
        return this.getOrCreateMapForCurrentThread().get(feature.name());
    }

    public void setFeatureState(FeatureState featureState) {
        Map<String, FeatureState> featureMap = this.getOrCreateMapForCurrentThread();
        featureMap.put(featureState.getFeature().name(), featureState);
        this.threadLocalFeatureMap.set(featureMap);
        this.modificationState.set(true);
    }

    protected void setThreadLocalFeatureMap(Map<String, FeatureState> featureStateMap) {
        this.threadLocalFeatureMap.set(featureStateMap);
    }

    protected Map<String, FeatureState> getThreadLocalFeatureMap() {
        return this.threadLocalFeatureMap.get();
    }

    protected void setModificationState(Boolean modified) {
        this.modificationState.set(modified);
    }

    protected Boolean getModificationState() {
        return this.modificationState.get();
    }

    protected void resetThreadLocals() {
        this.threadLocalFeatureMap.remove();
        this.modificationState.remove();
    }

    private Map<String, FeatureState> getOrCreateMapForCurrentThread() {
        Map<String, FeatureState> featureStatesMap = this.threadLocalFeatureMap.get();
        if (featureStatesMap == null) {
            featureStatesMap = new HashMap<String, FeatureState>(1);
        }
        return featureStatesMap;
    }
}

