/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.remote.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.is24.common.hateoas.HateoasLinkProvider;
import de.is24.common.hystrix.HystrixConfiguration;
import de.is24.common.togglz.filter.CookieOverwritingPersistentStateRepositoryFilter;
import de.is24.common.togglz.filter.cookie.CookieHandler;
import de.is24.common.togglz.provider.MergingFeatureProvider;
import de.is24.common.togglz.provider.RemoteFeatureSwitchProvider;
import de.is24.common.togglz.remote.RemoteFeatureStatesClient;
import de.is24.common.togglz.remote.api.serialization.HalEnabledObjectMapper;
import de.is24.common.togglz.remote.config.TogglzRemoteClientSettings;
import de.is24.common.togglz.remote.http.PreEmptiveAuthHttpRequestFactory;
import de.is24.common.togglz.repository.NoOpStateRepository;
import de.is24.common.togglz.repository.RemoteEnabledStateRepository;
import java.util.ArrayList;
import org.apache.commons.lang.NotImplementedException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.togglz.core.bootstrap.TogglzBootstrap;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.FeatureManagerBuilder;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.spi.FeatureProvider;
import org.togglz.core.user.SingleUserProvider;
import org.togglz.core.user.UserProvider;

@Configuration
public class FeatureSwitchRemoteClientConfig {
    @Autowired
    private TogglzRemoteClientSettings togglzRemoteClientSettings;
    @Value(value="${togglz.editpage.path:/togglz/edit}")
    private String togglzEditPagePath;

    @Autowired
    @Bean
    public TogglzBootstrap togglzBootstrap(FeatureManager featureManager) {
        return () -> featureManager;
    }

    @Autowired
    @Bean
    public FeatureManager featureManager(FeatureProvider featureProvider, StateRepository cookieOverwritingPersistentStateRepository, UserProvider userProvider) {
        FeatureManagerBuilder featureManagerBuilder = new FeatureManagerBuilder();
        return featureManagerBuilder.name("remoteAccessFeatureManager").featureProvider(featureProvider).stateRepository(cookieOverwritingPersistentStateRepository).userProvider(userProvider).build();
    }

    @Autowired
    @Bean
    public StateRepository remoteEnabledStateRepository(RemoteFeatureStatesClient remoteFeatureStatesClient) {
        return new RemoteEnabledStateRepository(remoteFeatureStatesClient);
    }

    @Autowired
    @Bean
    public FeatureProvider featureProvider(RemoteFeatureStatesClient remoteFeatureStatesClient) {
        FeatureProvider localFeatureProvider = this.localFeatureProvider();
        return this.togglzRemoteClientSettings.isRemoteEnabled() ? new MergingFeatureProvider(localFeatureProvider, new RemoteFeatureSwitchProvider(remoteFeatureStatesClient)) : localFeatureProvider;
    }

    @Bean
    public FeatureProvider localFeatureProvider() {
        throw new NotImplementedException("\nTo use togglz you must define: \n\n @Bean\n  public FeatureProvider localFeatureProvider() {\n    return new EnumBasedFeatureProvider(YourFeatures.class);\n  }");
    }

    @Bean
    public UserProvider userProvider() {
        return new SingleUserProvider("admin", true);
    }

    @Bean
    public CookieHandler cookieHander() {
        throw new NotImplementedException("\nYou must define a CookieHandler in your configuration like so: \n\n @Bean\n  public CookieHandler cookieHandler() {\n    return new SimpleCookieHandler();\n  }");
    }

    @Autowired
    @Bean
    public CookieOverwritingPersistentStateRepositoryFilter cookieOverwritingPersistentStateRepository(StateRepository remoteEnabledStateRepository, FeatureProvider featureProvider, CookieHandler cookieHandler) {
        CookieOverwritingPersistentStateRepositoryFilter repository = new CookieOverwritingPersistentStateRepositoryFilter(this.togglzRemoteClientSettings.isRemoteEnabled() ? remoteEnabledStateRepository : this.localStateRepository(), featureProvider, cookieHandler);
        repository.setTogglzEditPagePath(this.togglzEditPagePath);
        return repository;
    }

    @Bean
    public StateRepository localStateRepository() {
        return new NoOpStateRepository();
    }

    @Autowired
    @Bean
    public RemoteFeatureStatesClient remoteFeatureStatesClient(HateoasLinkProvider featureSwitchHateoasLinkProvider, RestOperations remoteFeatureSwitchRemoteConfigurations) {
        return new RemoteFeatureStatesClient(remoteFeatureSwitchRemoteConfigurations, featureSwitchHateoasLinkProvider, this.togglzRemoteClientSettings.getBaseUri());
    }

    @Autowired
    @Bean
    public HateoasLinkProvider featureSwitchHateoasLinkProvider(RestOperations remoteFeatureSwitchRemoteConfigurations) {
        return new HateoasLinkProvider(remoteFeatureSwitchRemoteConfigurations);
    }

    @Bean
    public RestOperations remoteFeatureSwitchRemoteConfigurations() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        AuthScope authScope = new AuthScope(null, -1, null, null);
        credentialsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(this.togglzRemoteClientSettings.getUsername(), this.togglzRemoteClientSettings.getPassword()));
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new PreEmptiveAuthHttpRequestFactory((HttpClient)httpClient));
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>(1);
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setObjectMapper((ObjectMapper)new HalEnabledObjectMapper());
        messageConverters.add(messageConverter);
        restTemplate.setMessageConverters(messageConverters);
        return restTemplate;
    }

    @Bean
    public HystrixConfiguration hystrixConfiguration() {
        return new HystrixConfiguration(this.togglzRemoteClientSettings.getFallbackEnabled().booleanValue(), this.togglzRemoteClientSettings.getTimeoutInMilliseconds().intValue());
    }
}

