/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.provider;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.togglz.core.Feature;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.spi.FeatureProvider;

public class MergingFeatureProvider
implements FeatureProvider {
    public static final Comparator<Feature> FEATURE_COMPARATOR = new Comparator<Feature>(){

        @Override
        public int compare(Feature a, Feature b) {
            return a.name().compareTo(b.name());
        }
    };
    private final List<FeatureProvider> featureProviders;

    public MergingFeatureProvider(FeatureProvider ... featureProviders) {
        this.featureProviders = Arrays.asList(featureProviders);
    }

    public Set<Feature> getFeatures() {
        TreeSet<Feature> features = new TreeSet<Feature>(FEATURE_COMPARATOR);
        this.featureProviders.stream().forEachOrdered(featureProvider -> features.addAll(featureProvider.getFeatures()));
        return features;
    }

    public FeatureMetaData getMetaData(Feature feature) {
        return null;
    }
}

