/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.togglz.filter.cookie;

import de.is24.common.togglz.filter.cookie.CookieHandler;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleCookieHandler
implements CookieHandler {
    final String cookieName;
    final String cookiePath;

    public SimpleCookieHandler() {
        this("togglz", "/");
    }

    public SimpleCookieHandler(String cookieName, String cookiePath) {
        this.cookieName = cookieName;
        this.cookiePath = cookiePath;
    }

    @Override
    public String retrieveCookiePayload(HttpServletRequest request) {
        Optional<Cookie> cookieOptional = this.retrieveCookie(request);
        if (!cookieOptional.isPresent()) {
            return "";
        }
        return cookieOptional.get().getValue();
    }

    @Override
    public void savePayloadToCookie(String cookiePayload, HttpServletResponse response) {
        Cookie cookie = new Cookie(this.cookieName, cookiePayload);
        cookie.setPath(this.cookiePath);
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
    }

    private Optional<Cookie> retrieveCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        return this.findCookieByNameAndPath(cookies, this.cookieName, this.cookiePath);
    }

    private Optional<Cookie> findCookieByNameAndPath(Cookie[] cookies, String cookieName, String cookiePath) {
        Cookie[] nullSafeCookies = cookies != null ? cookies : new Cookie[]{};
        cookiePath = cookiePath == null ? "/" : cookiePath;
        int i = nullSafeCookies.length;
        while (i-- > 0) {
            String pathFromCookie;
            Cookie cookie = nullSafeCookies[i];
            if (!cookieName.equals(cookie.getName()) || !cookiePath.equals(pathFromCookie = cookie.getPath()) && (!"/".equals(cookiePath) || pathFromCookie != null)) continue;
            return Optional.of(cookie);
        }
        return Optional.empty();
    }
}

