/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.hateoas;

import de.is24.common.hateoas.HateoasRequestEntity;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;

public class HateoasLinkProvider {
    private final RestOperations restOperations;

    public HateoasLinkProvider(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    @Cacheable(value={"linksByName"})
    public Link getLinkByName(String href, String linkName) {
        ResponseEntity remoteResource = this.restOperations.exchange(href, HttpMethod.GET, HateoasRequestEntity.requestEntity(), ResourceSupport.class, new Object[0]);
        return ((ResourceSupport)remoteResource.getBody()).getLink(linkName);
    }

    @CacheEvict(value={"linksByName"}, allEntries=true)
    public void resetLinkCache() {
    }
}

