/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.remote.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.is24.common.abtesting.remote.RemoteConfigurationClient;
import de.is24.common.abtesting.remote.RemoteDecisionClient;
import de.is24.common.abtesting.remote.api.serialization.HalEnabledObjectMapper;
import de.is24.common.abtesting.remote.config.AbTestRemoteClientSettings;
import de.is24.common.abtesting.remote.http.PreEmptiveAuthHttpRequestFactory;
import de.is24.common.hateoas.HateoasLinkProvider;
import de.is24.common.hystrix.HystrixConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RemoteClientConfig {
    public static final MediaType APPLICATION_HAL_JSON = new MediaType("application", "hal+json");
    @Autowired
    private AbTestRemoteClientSettings abTestRemoteClientSettings;

    @Bean
    public AuthScope abTestAuthScope() {
        return new AuthScope(null, -1, null, null);
    }

    @Bean
    public UsernamePasswordCredentials abTestCredentials() {
        return new UsernamePasswordCredentials(this.abTestRemoteClientSettings.getUserName(), this.abTestRemoteClientSettings.getPassword());
    }

    @Bean
    public BasicCredentialsProvider abTestCredentialProvider() {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(this.abTestAuthScope(), (Credentials)this.abTestCredentials());
        return provider;
    }

    @Bean
    public HalEnabledObjectMapper halEnabledObjectMapper() {
        return new HalEnabledObjectMapper();
    }

    @Bean
    public HttpClientBuilder abTestHttpClientBuilder() {
        return HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)this.abTestCredentialProvider());
    }

    @Bean
    public CloseableHttpClient abTestHttpClient() {
        return this.abTestHttpClientBuilder().build();
    }

    @Bean
    public PreEmptiveAuthHttpRequestFactory abTestHttpClientFactory() {
        return new PreEmptiveAuthHttpRequestFactory((HttpClient)this.abTestHttpClient());
    }

    @Bean
    public RestTemplate abTestRestTemplate() {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.abTestHttpClientFactory());
        ArrayList<HttpMessageConverter> messageConverters = new ArrayList<HttpMessageConverter>();
        messageConverters.add(this.mappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        return restTemplate;
    }

    @Bean
    public HttpMessageConverter mappingJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter mapper = new MappingJackson2HttpMessageConverter();
        mapper.setObjectMapper((ObjectMapper)this.halEnabledObjectMapper());
        mapper.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, APPLICATION_HAL_JSON));
        return mapper;
    }

    @Bean
    public HystrixConfiguration hysterixConfiguration() {
        return new HystrixConfiguration(this.abTestRemoteClientSettings.isFallbackEnabled(), this.abTestRemoteClientSettings.getTimeoutInMilliseconds().intValue());
    }

    @Bean
    public HateoasLinkProvider hateoasLinkProvider() {
        return new HateoasLinkProvider((RestOperations)this.abTestRestTemplate());
    }

    @Bean
    public RemoteConfigurationClient remoteConfigurationClient() {
        return new RemoteConfigurationClient((RestOperations)this.abTestRestTemplate(), this.hateoasLinkProvider(), this.abTestRemoteClientSettings.getRemoteServiceBaseUri());
    }

    @Bean
    public RemoteDecisionClient remoteDecisionClient() {
        return new RemoteDecisionClient((RestOperations)this.abTestRestTemplate(), this.hateoasLinkProvider(), this.abTestRemoteClientSettings.getRemoteServiceBaseUri());
    }
}

