/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.remote.command;

import de.is24.common.abtesting.remote.api.AbTestDecision;
import de.is24.common.abtesting.remote.command.AbstractAbTestRemoteCommand;
import de.is24.common.hateoas.HateoasLinkProvider;
import de.is24.common.hateoas.HateoasRequestEntity;
import de.is24.common.hystrix.HystrixConfiguration;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;

public class GetRemoteDecisionsCommand
extends AbstractAbTestRemoteCommand<Resources<Resource<AbTestDecision>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetRemoteDecisionsCommand.class);
    private final String remoteApiUri;
    private final Long userSsoId;

    public GetRemoteDecisionsCommand(HystrixConfiguration hysterixConfiguration, RestOperations restOperations, HateoasLinkProvider hateoasLinkProvider, String remoteApiUri, Long userSsoId) {
        super(hysterixConfiguration.getConfiguration("AbTestRemoteGroup"), restOperations, hateoasLinkProvider);
        this.remoteApiUri = remoteApiUri;
        this.userSsoId = userSsoId;
    }

    protected Resources<Resource<AbTestDecision>> runCommand() throws Exception {
        Link linkToDecisions = this.getLinkByName(this.remoteApiUri, "abTestDecisions").expand(new Object[0]);
        Link linkToSearch = this.getLinkByName(linkToDecisions.getHref(), "search").expand(new Object[0]);
        Link linkToFindByTestAndUserId = this.getLinkByName(linkToSearch.getHref(), "findByUserSsoId").expand(new Object[]{this.userSsoId});
        ResponseEntity remoteDecisionsEntity = this.restOperations.exchange(linkToFindByTestAndUserId.getHref(), HttpMethod.GET, HateoasRequestEntity.requestEntity(), (ParameterizedTypeReference)new ParameterizedTypeReference<Resources<Resource<AbTestDecision>>>(){}, new Object[0]);
        return (Resources)remoteDecisionsEntity.getBody();
    }

    protected Resources<Resource<AbTestDecision>> getFallback() {
        LOGGER.warn("No decisions could be retrieved.", this.getFailedExecutionException());
        return new Resources(Collections.emptyList(), Collections.emptyList());
    }
}

