/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.remote.command;

import de.is24.common.abtesting.remote.api.AbTestDecision;
import de.is24.common.abtesting.remote.command.AbstractAbTestRemoteCommand;
import de.is24.common.hateoas.HateoasLinkProvider;
import de.is24.common.hateoas.HateoasRequestEntity;
import de.is24.common.hystrix.HystrixConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;

public class GetRemoteDecisionCommand
extends AbstractAbTestRemoteCommand<Resource<AbTestDecision>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetRemoteDecisionCommand.class);
    private final String remoteApiUri;
    private final String testName;
    private final Long userSsoId;

    public GetRemoteDecisionCommand(HystrixConfiguration hysterixConfiguration, RestOperations restOperations, HateoasLinkProvider hateoasLinkProvider, String remoteApiUri, Long userSsoId, String testName) {
        super(hysterixConfiguration.getConfiguration("AbTestRemoteGroup"), restOperations, hateoasLinkProvider);
        this.remoteApiUri = remoteApiUri;
        this.userSsoId = userSsoId;
        this.testName = testName;
    }

    protected Resource<AbTestDecision> runCommand() throws Exception {
        Link linkToDecisions = this.getLinkByName(this.remoteApiUri, "abTestDecisions").expand(new Object[0]);
        Link linkToSearch = this.getLinkByName(linkToDecisions.getHref(), "search").expand(new Object[0]);
        Link linkToFindByTestAndUserId = this.getLinkByName(linkToSearch.getHref(), "findByTestNameAndUserSsoId").expand(new Object[]{this.testName, this.userSsoId});
        ResponseEntity remoteDecisionsEntity = this.restOperations.exchange(linkToFindByTestAndUserId.getHref(), HttpMethod.GET, HateoasRequestEntity.requestEntity(), (ParameterizedTypeReference)new ParameterizedTypeReference<Resources<Resource<AbTestDecision>>>(){}, new Object[0]);
        Resources remoteDecisions = (Resources)remoteDecisionsEntity.getBody();
        if (remoteDecisions.iterator().hasNext()) {
            return (Resource)remoteDecisions.iterator().next();
        }
        return null;
    }

    protected String getCacheKey() {
        return this.testName + ":" + String.valueOf(this.userSsoId);
    }

    protected Resource<AbTestDecision> getFallback() {
        LOGGER.warn("No decision could be retrieved.", this.getFailedExecutionException());
        return null;
    }
}

