/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.remote.command;

import de.is24.common.abtesting.remote.api.AbTestConfiguration;
import de.is24.common.abtesting.remote.command.AbstractAbTestRemoteCommand;
import de.is24.common.abtesting.remote.command.PageableParameters;
import de.is24.common.hateoas.HateoasLinkProvider;
import de.is24.common.hateoas.HateoasRequestEntity;
import de.is24.common.hystrix.HystrixConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

public class GetRemoteConfigurationsCommand
extends AbstractAbTestRemoteCommand<Resources<Resource<AbTestConfiguration>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetRemoteConfigurationsCommand.class);
    private final String remoteApiUri;
    private final Map<PageableParameters, String> parameterMap;

    public GetRemoteConfigurationsCommand(HystrixConfiguration hysterixConfiguration, RestOperations restOperations, HateoasLinkProvider hateoasLinkProvider, String remoteConfigurationProviderUri, Map<PageableParameters, String> parameterMap) {
        super(hysterixConfiguration.getConfiguration("AbTestRemoteGroup"), restOperations, hateoasLinkProvider);
        this.remoteApiUri = remoteConfigurationProviderUri;
        this.parameterMap = parameterMap;
    }

    protected Resources<Resource<AbTestConfiguration>> runCommand() throws RestClientException {
        Map<String, String> stringMap = this.parameterMap.entrySet().stream().collect(Collectors.toMap(e -> ((PageableParameters)((Object)((Object)e.getKey()))).toString(), Map.Entry::getValue));
        Link linkToConfigurations = this.getLinkByName(this.remoteApiUri, "abTestConfigurations").expand(stringMap);
        LOGGER.info(this.parameterMap.toString());
        ResponseEntity responseEntity = this.restOperations.exchange(linkToConfigurations.getHref(), HttpMethod.GET, HateoasRequestEntity.requestEntity(), (ParameterizedTypeReference)new ParameterizedTypeReference<Resources<Resource<AbTestConfiguration>>>(){}, new Object[0]);
        return (Resources)responseEntity.getBody();
    }

    protected Resources<Resource<AbTestConfiguration>> getFallback() {
        LOGGER.warn("No configuration could be retrieved. Using empty remote configuration.", this.getFailedExecutionException());
        return new Resources(Collections.emptyList(), Collections.emptyList());
    }
}

