/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.remote.command;

import de.is24.common.abtesting.remote.api.AbTestConfiguration;
import de.is24.common.abtesting.remote.command.AbstractAbTestRemoteCommand;
import de.is24.common.hateoas.HateoasLinkProvider;
import de.is24.common.hateoas.HateoasRequestEntity;
import de.is24.common.hystrix.HystrixConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;

public class DeleteRemoteConfigurationCommand
extends AbstractAbTestRemoteCommand<HttpStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteRemoteConfigurationCommand.class);
    private String remoteApiUri;
    private AbTestConfiguration configurationToDelete;

    public DeleteRemoteConfigurationCommand(HystrixConfiguration hysterixConfiguration, RestOperations restOperations, HateoasLinkProvider hateoasLinkProvider, String remoteApiUri, AbTestConfiguration configurationToDelete) {
        super(hysterixConfiguration.getConfiguration("AbTestRemoteGroup"), restOperations, hateoasLinkProvider);
        this.remoteApiUri = remoteApiUri;
        this.configurationToDelete = configurationToDelete;
    }

    protected HttpStatus runCommand() throws Exception {
        HttpStatus statusCode = this.deleteDecisionsOfConfigurationToDelete();
        if (statusCode != HttpStatus.OK) {
            LOGGER.warn("Received unexpected answer when deleting all test decisions for test {}. Status code {}", (Object)this.configurationToDelete.getName(), (Object)statusCode);
            return statusCode;
        }
        statusCode = this.deleteConfiguration();
        if (statusCode != HttpStatus.NO_CONTENT) {
            LOGGER.warn("Received unexpected answer when deleting test configuration {}. Status code {}", (Object)this.configurationToDelete.getName(), (Object)statusCode);
        }
        return statusCode;
    }

    private HttpStatus deleteDecisionsOfConfigurationToDelete() {
        Link linkToDecisions = this.getLinkByName(this.remoteApiUri, "abTestDecisions").expand(new Object[0]);
        Link linkToSearch = this.getLinkByName(linkToDecisions.getHref(), "search").expand(new Object[0]);
        Link linkToDeleteByTestName = this.getLinkByName(linkToSearch.getHref(), "deleteByTestName").expand(new Object[]{this.configurationToDelete.getName()});
        ResponseEntity response = this.restOperations.exchange(linkToDeleteByTestName.getHref(), HttpMethod.GET, HateoasRequestEntity.requestEntity(), (Class)null, new Object[0]);
        return response.getStatusCode();
    }

    private HttpStatus deleteConfiguration() {
        Link linkToConfigurations = this.getLinkByName(this.remoteApiUri, "abTestConfigurations").expand(new Object[0]);
        ResponseEntity response = this.restOperations.exchange(linkToConfigurations.getHref() + "/" + this.configurationToDelete.getName(), HttpMethod.DELETE, null, (Class)null, new Object[0]);
        return response.getStatusCode();
    }

    protected HttpStatus getFallback() {
        LOGGER.warn("Failed to delete ab test configuration.", this.getFailedExecutionException());
        return HttpStatus.SERVICE_UNAVAILABLE;
    }
}

