/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.remote;

import de.is24.common.abtesting.remote.AbTestRemoteClient;
import de.is24.common.abtesting.remote.api.AbTestDecision;
import de.is24.common.abtesting.remote.command.CreateOrUpdateRemoteDecisionCommand;
import de.is24.common.abtesting.remote.command.CreateRemoteDecisionCommand;
import de.is24.common.abtesting.remote.command.GetRemoteDecisionCommand;
import de.is24.common.abtesting.remote.command.GetRemoteDecisionsCommand;
import de.is24.common.hateoas.HateoasLinkProvider;
import java.util.ArrayList;
import java.util.List;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestOperations;

public class RemoteDecisionClient
extends AbTestRemoteClient {
    public RemoteDecisionClient(RestOperations restOperations, HateoasLinkProvider hateoasLinkProvider, String remoteServiceBaseUri) {
        super(restOperations, hateoasLinkProvider, remoteServiceBaseUri);
    }

    public List<AbTestDecision> getDecisionsFor(Long userId) {
        Resources abTestDecisionResources = (Resources)new GetRemoteDecisionsCommand(this.hysterixConfiguration, this.restOperations, this.hateoasLinkProvider, this.remoteServiceBaseUri, userId).execute();
        ArrayList<AbTestDecision> fromApi = new ArrayList<AbTestDecision>();
        for (Resource abTestDecisionResource : abTestDecisionResources) {
            AbTestDecision abTestDecision = (AbTestDecision)abTestDecisionResource.getContent();
            fromApi.add(abTestDecision);
        }
        return fromApi;
    }

    public AbTestDecision getDecisionFor(Long userId, String testName) {
        Resource abTestDecisionResource = (Resource)new GetRemoteDecisionCommand(this.hysterixConfiguration, this.restOperations, this.hateoasLinkProvider, this.remoteServiceBaseUri, userId, testName).execute();
        if (abTestDecisionResource != null) {
            return (AbTestDecision)abTestDecisionResource.getContent();
        }
        return null;
    }

    public HttpStatus createDecision(Long userId, AbTestDecision newDecision) {
        return (HttpStatus)new CreateRemoteDecisionCommand(this.hysterixConfiguration, this.restOperations, this.hateoasLinkProvider, this.remoteServiceBaseUri, newDecision.getTestName(), newDecision.getVariantId(), userId).execute();
    }

    public HttpStatus createOrUpdateDecision(Long userId, AbTestDecision newDecision) {
        return (HttpStatus)new CreateOrUpdateRemoteDecisionCommand(this.hysterixConfiguration, this.restOperations, this.hateoasLinkProvider, this.remoteServiceBaseUri, newDecision.getTestName(), newDecision.getVariantId(), userId).execute();
    }
}

