/*
 * Decompiled with CFR 0.152.
 */
package de.is24.common.abtesting.remote;

import de.is24.common.abtesting.remote.AbTestRemoteClient;
import de.is24.common.abtesting.remote.api.AbTestConfiguration;
import de.is24.common.abtesting.remote.command.CreateRemoteConfigurationCommand;
import de.is24.common.abtesting.remote.command.DeleteRemoteConfigurationCommand;
import de.is24.common.abtesting.remote.command.GetRemoteConfigurationsCommand;
import de.is24.common.abtesting.remote.command.UpdateRemoteConfigurationCommand;
import de.is24.common.hateoas.HateoasLinkProvider;
import java.util.HashMap;
import java.util.Map;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestOperations;

public class RemoteConfigurationClient
extends AbTestRemoteClient {
    public RemoteConfigurationClient(RestOperations restOperations, HateoasLinkProvider hateoasLinkProvider, String remoteServiceBaseUri) {
        super(restOperations, hateoasLinkProvider, remoteServiceBaseUri);
    }

    public Map<String, AbTestConfiguration> getRemoteConfiguration() {
        Resources abTestConfigurationResources = (Resources)new GetRemoteConfigurationsCommand(this.hysterixConfiguration, this.restOperations, this.hateoasLinkProvider, this.remoteServiceBaseUri).execute();
        HashMap<String, AbTestConfiguration> fromApi = new HashMap<String, AbTestConfiguration>();
        for (Resource remoteConfiguration : abTestConfigurationResources) {
            AbTestConfiguration abTestConfiguration = (AbTestConfiguration)remoteConfiguration.getContent();
            fromApi.put(abTestConfiguration.getName(), abTestConfiguration);
        }
        return fromApi;
    }

    public HttpStatus createRemoteConfiguration(AbTestConfiguration testConfiguration) {
        HttpStatus answerFromApi = (HttpStatus)new CreateRemoteConfigurationCommand(this.hysterixConfiguration, this.restOperations, this.hateoasLinkProvider, this.remoteServiceBaseUri, testConfiguration).execute();
        return answerFromApi;
    }

    public HttpStatus deleteRemoteConfiguration(AbTestConfiguration testConfiguration) {
        HttpStatus answerFromApi = (HttpStatus)new DeleteRemoteConfigurationCommand(this.hysterixConfiguration, this.restOperations, this.hateoasLinkProvider, this.remoteServiceBaseUri, testConfiguration).execute();
        return answerFromApi;
    }

    public HttpStatus updateRemoteConfiguration(AbTestConfiguration abTestConfiguration) {
        HttpStatus answerFromApi = (HttpStatus)new UpdateRemoteConfigurationCommand(this.hysterixConfiguration, this.restOperations, this.hateoasLinkProvider, this.remoteServiceBaseUri, abTestConfiguration).execute();
        return answerFromApi;
    }
}

