/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.wrapper;

import de.is24.util.monitoring.InApplicationMonitor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class GenericMonitoringWrapper<E>
implements InvocationHandler {
    private final Class<E> targetClass;
    private final Object target;
    private final TimingReporter reporter;

    public static <E> E wrapObject(Class<E> clazz, Object target) {
        return GenericMonitoringWrapper.wrapObject(clazz, target, new InApplicationMonitorTimingReporter());
    }

    public static <E> E wrapObject(Class<E> clazz, Object target, TimingReporter timingReporter) {
        return (E)Proxy.newProxyInstance(GenericMonitoringWrapper.class.getClassLoader(), new Class[]{clazz}, new GenericMonitoringWrapper<E>(clazz, target, timingReporter));
    }

    protected GenericMonitoringWrapper(Class<E> targetClass, Object target, TimingReporter timingReporter) {
        this.targetClass = targetClass;
        this.target = target;
        this.reporter = timingReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = null;
        try {
            result = method.invoke(this.target, args);
            if (result != null && !method.getReturnType().equals(Void.TYPE) && method.getReturnType().isInterface()) {
                result = GenericMonitoringWrapper.wrapObject(method.getReturnType(), result, this.reporter);
            }
        }
        catch (InvocationTargetException t) {
            if (t.getCause() != null) {
                throw t.getCause();
            }
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.reporter.reportTimedOperation(this.targetClass, method, startTime, endTime);
        }
        return result;
    }

    public static class InApplicationMonitorTimingReporter
    implements TimingReporter {
        @Override
        public void reportTimedOperation(Class<?> targetClass, Method targetMethod, long startTime, long endTime) {
            InApplicationMonitor.getInstance().addTimerMeasurement(targetClass.getName() + "." + targetMethod.getName(), startTime, endTime);
        }
    }

    public static interface TimingReporter {
        public void reportTimedOperation(Class<?> var1, Method var2, long var3, long var5);
    }
}

