/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.status;

import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.StateValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampledData {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampledData.class);
    final int maxIndex = 15;
    long[] successData = new long[15];
    long[] failureData = new long[15];
    int currentPointer = 0;
    private final String name;

    public SampledData(String name) {
        this.name = name;
        this.initData();
        InApplicationMonitor.getInstance().registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                return (long)(SampledData.this.getOnMinuteFailureRate() * 100.0f);
            }

            @Override
            public String getName() {
                return SampledData.this.name + ".oneMinuteFailureRate";
            }
        });
    }

    public void addSample(long successCount, long failureCount) {
        this.incrementCurrentPointer();
        this.failureData[this.currentPointer] = failureCount;
        this.successData[this.currentPointer] = successCount;
    }

    private void incrementCurrentPointer() {
        ++this.currentPointer;
        if (this.currentPointer >= 15) {
            this.currentPointer = 0;
        }
    }

    private void initData() {
        for (int i = 0; i < 15; ++i) {
            this.failureData[i] = 0L;
            this.successData[i] = 0L;
        }
    }

    public float getOnMinuteFailureRate() {
        return this.calcRateOverInterval(1);
    }

    public float getFiveMinuteFailureRate() {
        return this.calcRateOverInterval(5);
    }

    public Float getFifteenMinuteFailureRate() {
        return Float.valueOf(this.calcRateOverInterval(15));
    }

    private float calcRateOverInterval(int interval) {
        int currentIndex = this.currentPointer;
        int successCount = 0;
        int failureCount = 0;
        for (int count = 0; count < interval; ++count) {
            successCount = (int)((long)successCount + this.successData[currentIndex]);
            failureCount = (int)((long)failureCount + this.failureData[currentIndex]);
            if (--currentIndex >= 0) continue;
            currentIndex = 14;
        }
        return this.calcFailureRate(successCount, failureCount);
    }

    private float calcFailureRate(long successCount, long failureCount) {
        LOGGER.debug("success count {}, failureCount : {}", (Object)successCount, (Object)failureCount);
        long total = successCount + failureCount;
        return total == 0L ? 0.0f : (float)failureCount / (float)total;
    }
}

