/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.jmx;

import de.is24.util.monitoring.MultiValueProvider;
import de.is24.util.monitoring.State;
import java.util.Collection;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class MultiValueProviderHelper {
    private MultiValueProvider reportable;
    private String[] itemNames;
    private OpenType[] itemTypes;
    private Object[] itemValues;

    public MultiValueProviderHelper(MultiValueProvider reportable) {
        this.reportable = reportable;
        this.loadFields();
    }

    private void loadFields() {
        Collection<State> values = this.reportable.getValues();
        int stateCount = values.size();
        this.itemNames = new String[stateCount];
        this.itemTypes = new OpenType[stateCount];
        this.itemValues = new Object[stateCount];
        int index = 0;
        for (State state : values) {
            this.itemNames[index] = state.name;
            this.itemTypes[index] = SimpleType.LONG;
            this.itemValues[index] = state.value;
            ++index;
        }
    }

    public CompositeData toComposite() {
        try {
            CompositeType compositeType = new CompositeType("testCompositeType", "a text composite", this.itemNames, this.itemNames, this.itemTypes);
            return new CompositeDataSupport(compositeType, this.itemNames, this.itemValues);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

