/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.CorePlugin;
import de.is24.util.monitoring.Historizable;
import de.is24.util.monitoring.MonitorPlugin;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.ReportableObserver;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Version;
import de.is24.util.monitoring.keyhandler.DefaultKeyEscaper;
import de.is24.util.monitoring.keyhandler.KeyHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InApplicationMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InApplicationMonitor.class);
    protected static final Object semaphore = new Object();
    private volatile boolean monitorActive = true;
    private final CopyOnWriteArrayList<MonitorPlugin> plugins = new CopyOnWriteArrayList();
    private volatile KeyHandler keyHandler;
    private volatile CorePlugin corePlugin;
    protected static InApplicationMonitor instance;

    protected InApplicationMonitor(CorePlugin corePlugin, KeyHandler keyHandler) {
        this.keyHandler = keyHandler;
        this.corePlugin = corePlugin;
        this.registerPlugin(corePlugin);
    }

    public static InApplicationMonitor getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InApplicationMonitor initInstance(CorePlugin corePlugin, KeyHandler keyHandler) {
        CorePlugin previousCorePlugin;
        Object object = semaphore;
        synchronized (object) {
            LOGGER.info("+++ initializing InApplicationMonitor() +++");
            InApplicationMonitor.instance.keyHandler = keyHandler;
            LOGGER.info("syncing from previous core plugin");
            previousCorePlugin = InApplicationMonitor.instance.corePlugin;
            corePlugin.syncFrom(previousCorePlugin);
            InApplicationMonitor.instance.plugins.add(corePlugin);
            InApplicationMonitor.instance.plugins.remove(previousCorePlugin);
            InApplicationMonitor.instance.corePlugin = corePlugin;
            LOGGER.info("InApplicationMonitor updated successfully.");
        }
        if (previousCorePlugin != null && previousCorePlugin != corePlugin) {
            previousCorePlugin.destroy();
        }
        return instance;
    }

    public void activate() {
        this.monitorActive = true;
    }

    public void deactivate() {
        this.monitorActive = false;
    }

    public boolean isMonitorActive() {
        return this.monitorActive;
    }

    @Deprecated
    public int getMaxHistoryEntriesToKeep() {
        return this.getCorePlugin().getMaxHistoryEntriesToKeep();
    }

    @Deprecated
    public void setMaxHistoryEntriesToKeep(int aMaxHistoryEntriesToKeep) {
        this.getCorePlugin().setMaxHistoryEntriesToKeep(aMaxHistoryEntriesToKeep);
    }

    @Deprecated
    public void addReportableObserver(ReportableObserver reportableObserver) {
        this.getCorePlugin().addReportableObserver(reportableObserver);
    }

    @Deprecated
    public void removeReportableObserver(ReportableObserver reportableObserver) {
        this.getCorePlugin().removeReportableObserver(reportableObserver);
    }

    @Deprecated
    public void reportInto(ReportVisitor reportVisitor) {
        this.getCorePlugin().reportInto(reportVisitor);
    }

    public void incrementCounter(String name) {
        this.incrementCounter(name, 1);
    }

    public void incrementHighRateCounter(String name) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.getPlugins()) {
                p.incrementHighRateCounter(escapedName, 1);
            }
        }
    }

    public void incrementCounter(String name, int increment) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.getPlugins()) {
                p.incrementCounter(escapedName, increment);
            }
        }
    }

    public void initializeCounter(String name) {
        String escapedName = this.keyHandler.handle(name);
        for (MonitorPlugin p : this.getPlugins()) {
            p.initializeCounter(escapedName);
        }
    }

    public void addTimerMeasurement(String name, long timing) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.getPlugins()) {
                p.addTimerMeasurement(escapedName, timing);
            }
        }
    }

    public void addSingleEventTimerMeasurement(String name, long timing) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.getPlugins()) {
                p.addSingleEventTimerMeasurement(escapedName, timing);
            }
        }
    }

    public void addHighRateTimerMeasurement(String name, long timing) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.getPlugins()) {
                p.addHighRateTimerMeasurement(escapedName, timing);
            }
        }
    }

    public void addTimerMeasurement(String name, long begin, long end) {
        this.addTimerMeasurement(name, end - begin);
    }

    public void initializeTimerMeasurement(String name) {
        String escapedName = this.keyHandler.handle(name);
        for (MonitorPlugin p : this.getPlugins()) {
            p.initializeTimerMeasurement(escapedName);
        }
    }

    public void registerStateValue(StateValueProvider stateValueProvider) {
        this.getCorePlugin().registerStateValue(stateValueProvider);
    }

    public void registerVersion(String name, String version) {
        Version versionToAdd = new Version(this.keyHandler.handle(name), version);
        this.getCorePlugin().registerVersion(versionToAdd);
    }

    public void addHistorizable(Historizable historizable) {
        this.getCorePlugin().addHistorizable(this.keyHandler.handle(historizable.getName()), historizable);
    }

    public void registerPlugin(MonitorPlugin plugin) {
        this.plugins.addIfAbsent(plugin);
    }

    public List<String> getRegisteredPluginKeys() {
        ArrayList<String> installedPluginKeys = new ArrayList<String>();
        for (MonitorPlugin plugin : this.getPlugins()) {
            installedPluginKeys.add(plugin.getUniqueName());
        }
        return installedPluginKeys;
    }

    public void removeAllPlugins() {
        this.getPlugins().clear();
        this.getPlugins().add(this.corePlugin);
    }

    protected KeyHandler getKeyHandler() {
        return this.keyHandler;
    }

    protected List<MonitorPlugin> getPlugins() {
        return this.plugins;
    }

    public CorePlugin getCorePlugin() {
        return this.corePlugin;
    }

    public void setThreadLocalState() {
        throw new UnsupportedOperationException("setThreadLocalState not supported on production InApplicationMonitor, initialize Testing Version");
    }

    public void resetThreadLocalState() {
        throw new UnsupportedOperationException("resetThreadLocalState not supported on production InApplicationMonitor, initialize Testing Version");
    }

    static {
        DefaultKeyEscaper keyHandler = new DefaultKeyEscaper();
        CorePlugin corePlugin = new CorePlugin(null, keyHandler);
        instance = new InApplicationMonitor(corePlugin, keyHandler);
    }
}

