/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.status;

import de.is24.util.monitoring.Counter;
import de.is24.util.monitoring.Reportable;
import de.is24.util.monitoring.status.SampledData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceState {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceState.class);
    private final String name;
    private final String successCounterKey;
    private final String errorCounterKey;
    private long previousSuccessCounterValue = Long.MAX_VALUE;
    private long previousErrorCounterValue = Long.MAX_VALUE;
    private Counter successCounter;
    private Counter errorCounter;
    private SampledData sampledData;

    public ServiceState(String name, String successCounterKey, String errorCounterKey) {
        this.name = name;
        this.successCounterKey = successCounterKey;
        this.errorCounterKey = errorCounterKey;
        this.sampledData = new SampledData(name);
    }

    public void check() {
        long successCounterCount = this.successCounter == null ? Long.MAX_VALUE : this.successCounter.getCount();
        long errorCounterCount = this.errorCounter == null ? Long.MAX_VALUE : this.errorCounter.getCount();
        long errorDelta = 0L;
        if (this.previousErrorCounterValue <= errorCounterCount) {
            errorDelta = errorCounterCount - this.previousErrorCounterValue;
        }
        if (this.previousSuccessCounterValue <= successCounterCount) {
            long successDelta = successCounterCount - this.previousSuccessCounterValue;
            LOGGER.debug("successDelta : {} errorDelta : {}", (Object)successDelta, (Object)errorDelta);
            this.sampledData.addSample(successDelta, errorDelta);
        }
        this.previousErrorCounterValue = errorCounterCount;
        this.previousSuccessCounterValue = successCounterCount;
    }

    public void checkForReportable(Reportable reportable) {
        LOGGER.debug("checking reportable with name {}", (Object)reportable.getName());
        if (this.successCounter == null && reportable instanceof Counter && reportable.getName().equals(this.successCounterKey)) {
            LOGGER.info("found {}", (Object)this.successCounterKey);
            this.successCounter = (Counter)reportable;
        }
        if (this.errorCounter == null && reportable instanceof Counter && reportable.getName().equals(this.errorCounterKey)) {
            LOGGER.info("found {}", (Object)this.errorCounterKey);
            this.errorCounter = (Counter)reportable;
        }
    }

    public String getName() {
        return this.name;
    }
}

