/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.jmx;

import de.is24.util.monitoring.MultiValueProvider;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.State;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXExporter
implements MultiValueProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMXExporter.class);
    private static final String JMXEXPORTER = "JMXExporter";
    private final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final Set<ObjectName> objectPatterns = Collections.synchronizedSet(new HashSet());

    public JMXExporter() {
    }

    public JMXExporter(String pattern) throws MalformedObjectNameException {
        this();
        this.addPattern(pattern);
    }

    public void addPattern(String pattern) throws MalformedObjectNameException {
        this.objectPatterns.add(new ObjectName(pattern));
    }

    public List<ObjectName> listPatterns() {
        return new ArrayList<ObjectName>(this.objectPatterns);
    }

    public boolean removePattern(String pattern) throws MalformedObjectNameException {
        return this.objectPatterns.remove(new ObjectName(pattern));
    }

    @Override
    public Collection<State> getValues() {
        ArrayList<State> result = new ArrayList<State>();
        this.searchAndLogNumericAttributes(result);
        return result;
    }

    @Override
    public String getName() {
        return JMXEXPORTER;
    }

    @Override
    public void accept(ReportVisitor visitor) {
    }

    protected void searchAndLogNumericAttributes(List<State> result) {
        Map<ObjectName, MBeanInfo> mBeanInfoMap = this.getMBeanInfos();
        for (Map.Entry<ObjectName, MBeanInfo> entry : mBeanInfoMap.entrySet()) {
            MBeanAttributeInfo[] attributes;
            ObjectName name = entry.getKey();
            MBeanInfo mBeanInfo = entry.getValue();
            for (MBeanAttributeInfo info : attributes = mBeanInfo.getAttributes()) {
                try {
                    Object valueObject = this.platformMBeanServer.getAttribute(name, info.getName());
                    String attributeName = this.getBaseName(name);
                    this.handleObject(attributeName, info.getName(), valueObject, result);
                }
                catch (Exception e) {
                    if (e.getCause() != null && e.getCause().getClass().equals(UnsupportedOperationException.class)) {
                        LOGGER.debug("ignoring unsupported numeric MBean Attribute {} {} {}", (Object)name, (Object)info);
                        continue;
                    }
                    LOGGER.info("Error accessing numeric MBean Attribute {} {} {}", new Object[]{name, info, e.getMessage()});
                }
            }
        }
    }

    private void handleObject(String baseName, String path, Object valueObject, List<State> result) {
        LOGGER.debug("handling {}", (Object)baseName);
        Long value = null;
        if (valueObject instanceof Long) {
            value = (long)((Long)valueObject);
        } else if (valueObject instanceof Boolean) {
            value = (Boolean)valueObject != false ? 1L : 0L;
        } else if (valueObject instanceof Integer) {
            value = ((Integer)valueObject).longValue();
        } else if (valueObject instanceof Short) {
            value = ((Short)valueObject).longValue();
        } else if (valueObject instanceof Double) {
            value = ((Double)valueObject).longValue();
        } else if (valueObject instanceof Float) {
            value = ((Float)valueObject).longValue();
        } else if (valueObject instanceof CompositeData) {
            this.logComposite(baseName, path, (CompositeData)valueObject, result);
        }
        if (value != null) {
            result.add(this.createState(baseName, path, value));
        }
    }

    private void logComposite(String attributeName, String path, CompositeData obj, List<State> result) {
        for (String key : obj.getCompositeType().keySet()) {
            String additionalPath = path == null ? key : path + "." + key;
            Object valueObject = obj.get(key);
            if (valueObject instanceof CompositeData) {
                this.logComposite(attributeName, additionalPath, (CompositeData)valueObject, result);
                continue;
            }
            if (valueObject == null) continue;
            this.handleObject(attributeName, additionalPath, valueObject, result);
        }
    }

    private State createState(String baseName, String path, Long value) {
        return new State(baseName, path, value);
    }

    private String getBaseName(ObjectName name) {
        StringBuilder builder = new StringBuilder();
        builder.append(name.getDomain()).append(".").append(name.getCanonicalKeyPropertyListString());
        return builder.toString();
    }

    protected Map<ObjectName, MBeanInfo> getMBeanInfos() {
        try {
            HashMap<ObjectName, MBeanInfo> result = new HashMap<ObjectName, MBeanInfo>();
            for (ObjectName objectPattern : this.objectPatterns) {
                Set<ObjectName> objectNames = this.platformMBeanServer.queryNames(objectPattern, null);
                for (ObjectName name : objectNames) {
                    result.put(name, this.platformMBeanServer.getMBeanInfo(name));
                }
            }
            LOGGER.info("searching for MBeans using {} patterns found {} matching Bean Infos", (Object)this.objectPatterns.size(), (Object)result.size());
            return result;
        }
        catch (Exception e) {
            LOGGER.warn("oops", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void readFromDirectory(String path) {
        LOGGER.info("reading JMXExporter Patterns from directory {}", (Object)path);
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            Collection files = FileUtils.listFiles((File)dir, null, (boolean)false);
            if (files.size() == 0) {
                LOGGER.warn("no files found in readFromDirectory {}", (Object)path);
            }
            for (File file : files) {
                this.readFromFile(file);
            }
        } else {
            LOGGER.warn("JMXExporter config dir {} does not exist.", (Object)dir.getAbsolutePath());
        }
    }

    public void readFromFile(String filename) {
        this.readFromFile(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile(File file) {
        block9: {
            LineIterator it;
            LOGGER.info("reading JMXExporter Patterns from file {}", (Object)file.getAbsolutePath());
            try {
                it = FileUtils.lineIterator((File)file, (String)"UTF-8");
            }
            catch (IOException e) {
                LOGGER.warn("Error while reading patterns from file " + file.getAbsolutePath(), (Throwable)e);
                throw new RuntimeException(e);
            }
            block7: while (true) {
                while (it.hasNext()) {
                    String pattern = it.nextLine();
                    if (pattern.length() <= 0) continue;
                    try {
                        this.addPattern(pattern);
                        continue block7;
                    }
                    catch (MalformedObjectNameException e) {
                        LOGGER.warn("Ignoring malformed ObjectName pattern while applying pattern {} from file {} {} ", new Object[]{pattern, file.getAbsolutePath(), e.getMessage()});
                    }
                }
                break block9;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                LineIterator.closeQuietly((LineIterator)it);
            }
        }
    }
}

