/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.jmx;

import de.is24.util.monitoring.MultiValueProvider;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.State;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXExporter
implements MultiValueProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMXExporter.class);
    private static final String JMXEXPORTER = "JMXExporter";
    private final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName objectPattern;
    private final String pattern;
    private String name;

    public JMXExporter(String pattern) throws MalformedObjectNameException {
        this.pattern = pattern;
        this.objectPattern = new ObjectName(pattern);
        this.name = "JMXExporter." + pattern;
    }

    @Override
    public Collection<State> getValues() {
        ArrayList<State> result = new ArrayList<State>();
        this.searchAndLogNumericAttributes(result);
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void accept(ReportVisitor visitor) {
    }

    protected void searchAndLogNumericAttributes(List<State> result) {
        Map<ObjectName, MBeanInfo> mBeanInfoMap = this.getMBeanInfos();
        for (Map.Entry<ObjectName, MBeanInfo> entry : mBeanInfoMap.entrySet()) {
            MBeanAttributeInfo[] attributes;
            ObjectName name = entry.getKey();
            MBeanInfo mBeanInfo = entry.getValue();
            for (MBeanAttributeInfo info : attributes = mBeanInfo.getAttributes()) {
                try {
                    Object valueObject = this.platformMBeanServer.getAttribute(name, info.getName());
                    String attributeName = this.getAttributeName(name, info);
                    this.handleObject(attributeName, null, valueObject, result);
                }
                catch (Exception e) {
                    LOGGER.info("Error accessing numeric MBean Attribute {} {} {}", new Object[]{name, info, e.getMessage()});
                }
            }
        }
    }

    private void handleObject(String attributeName, String path, Object valueObject, List<State> result) {
        LOGGER.debug("handling {}", (Object)attributeName);
        Long value = null;
        if (valueObject instanceof Long) {
            value = (long)((Long)valueObject);
        } else if (valueObject instanceof Boolean) {
            value = (Boolean)valueObject != false ? 1L : 0L;
        } else if (valueObject instanceof Integer) {
            value = ((Integer)valueObject).longValue();
        } else if (valueObject instanceof Short) {
            value = ((Short)valueObject).longValue();
        } else if (valueObject instanceof Double) {
            value = ((Double)valueObject).longValue();
        } else if (valueObject instanceof Float) {
            value = ((Float)valueObject).longValue();
        } else if (valueObject instanceof CompositeData) {
            this.logComposite(attributeName, path, (CompositeData)valueObject, result);
        }
        if (value != null) {
            result.add(this.createState(attributeName, path, value));
        }
    }

    private void logComposite(String attributeName, String path, CompositeData obj, List<State> result) {
        for (String key : obj.getCompositeType().keySet()) {
            String additionalPath = path == null ? key : path + "." + key;
            Object valueObject = obj.get(key);
            if (valueObject instanceof CompositeData) {
                this.logComposite(attributeName, additionalPath, (CompositeData)valueObject, result);
                continue;
            }
            if (valueObject == null) continue;
            this.handleObject(attributeName, additionalPath, valueObject, result);
        }
    }

    private State createState(String attributeName, String path, Long value) {
        String fullName = attributeName + (path != null ? "." + path : "");
        return new State(JMXEXPORTER, fullName, value);
    }

    private String getAttributeName(ObjectName name, MBeanAttributeInfo info) {
        StringBuilder builder = new StringBuilder();
        builder.append(name.getDomain()).append(".").append(name.getCanonicalKeyPropertyListString()).append(".").append(info.getName());
        return builder.toString().replaceAll("[:* =]", "_").replaceAll(",", ".");
    }

    protected Map<ObjectName, MBeanInfo> getMBeanInfos() {
        try {
            Set<ObjectName> objectNames = this.platformMBeanServer.queryNames(this.objectPattern, null);
            HashMap<ObjectName, MBeanInfo> result = new HashMap<ObjectName, MBeanInfo>(objectNames.size());
            for (ObjectName name : objectNames) {
                result.put(name, this.platformMBeanServer.getMBeanInfo(name));
            }
            LOGGER.info("searching for MBeans matching pattern  {} found {} Bean Infos", (Object)this.pattern, (Object)result.size());
            return result;
        }
        catch (Exception e) {
            LOGGER.warn("oops", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

