/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.status;

import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.Reportable;
import de.is24.util.monitoring.ReportableObserver;
import de.is24.util.monitoring.status.ServiceState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ServiceStateManager
implements ReportableObserver {
    private static final Logger LOGGER = Logger.getLogger(ServiceStateManager.class);
    private ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor();
    private Map<String, ServiceState> serviceStates;

    public ServiceStateManager() {
        this.ex.scheduleAtFixedRate(new ServiceStateJob(), 5L, 60L, TimeUnit.SECONDS);
        this.serviceStates = new ConcurrentHashMap<String, ServiceState>();
    }

    public void addServiceState(ServiceState serviceState) {
        this.serviceStates.put(serviceState.getName(), serviceState);
    }

    public void initialize() {
        InApplicationMonitor.getInstance().getCorePlugin().addReportableObserver(this);
    }

    @Override
    public void addNewReportable(Reportable reportable) {
        for (ServiceState state : this.serviceStates.values()) {
            state.checkForReportable(reportable);
        }
    }

    public void shutdown() {
        InApplicationMonitor.getInstance().getCorePlugin().removeReportableObserver(this);
        this.ex.shutdown();
    }

    private class ServiceStateJob
    implements Runnable {
        private ServiceStateJob() {
        }

        @Override
        public void run() {
            LOGGER.debug((Object)"updating service state");
            for (ServiceState state : ServiceStateManager.this.serviceStates.values()) {
                LOGGER.debug((Object)("checking " + state.getName()));
                state.check();
            }
            LOGGER.debug((Object)"done with service state");
        }
    }
}

