/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.state2graphite;

import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.MultiValueProvider;
import de.is24.util.monitoring.Reportable;
import de.is24.util.monitoring.ReportableObserver;
import de.is24.util.monitoring.State;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.state2graphite.GraphiteConnection;
import de.is24.util.monitoring.tools.LocalHostNameResolver;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class StateValuesToGraphite
implements ReportableObserver {
    private static final Logger LOGGER = Logger.getLogger(StateValuesToGraphite.class);
    private ScheduledExecutorService ex;
    private Map<String, StateValueProvider> stateValues;
    private Map<String, MultiValueProvider> multiValueProviders;
    private GraphiteConnection graphiteClient;

    public StateValuesToGraphite(String graphiteHost, int graphitePort, String appName) {
        this(appName, new LocalHostNameResolver(), new GraphiteConnection(graphiteHost, graphitePort));
    }

    StateValuesToGraphite(String appName, LocalHostNameResolver localHostNameResolver, GraphiteConnection graphiteClient) {
        this.graphiteClient = graphiteClient;
        String keyPrefix = appName + "." + localHostNameResolver.getLocalHostName() + ".states";
        this.stateValues = new ConcurrentHashMap<String, StateValueProvider>();
        this.multiValueProviders = new ConcurrentHashMap<String, MultiValueProvider>();
        InApplicationMonitor.getInstance().getCorePlugin().addReportableObserver(this);
        this.ex = Executors.newSingleThreadScheduledExecutor();
        this.ex.scheduleAtFixedRate(new ReportStateValuesJob(graphiteClient, keyPrefix), 1L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void addNewReportable(Reportable reportable) {
        if (reportable instanceof StateValueProvider) {
            this.stateValues.put(reportable.getName(), (StateValueProvider)reportable);
        } else if (reportable instanceof MultiValueProvider) {
            this.multiValueProviders.put(reportable.getName(), (MultiValueProvider)reportable);
        }
    }

    public void shutdown() {
        InApplicationMonitor.getInstance().getCorePlugin().removeReportableObserver(this);
        this.ex.shutdown();
    }

    public String toString() {
        return "StateValuesToGraphite:" + this.graphiteClient.toString();
    }

    private class ReportStateValuesJob
    implements Runnable {
        private final GraphiteConnection graphiteClient;
        private final String keyPrefix;

        public ReportStateValuesJob(GraphiteConnection graphiteClient, String keyPrefix) {
            this.graphiteClient = graphiteClient;
            this.keyPrefix = keyPrefix;
        }

        @Override
        public void run() {
            LOGGER.debug((Object)("writing " + StateValuesToGraphite.this.stateValues.size() + " state values to graphite"));
            Long curTimeInSec = System.currentTimeMillis() / 1000L;
            StringBuilder lines = new StringBuilder();
            this.addStateValues(curTimeInSec, lines);
            this.addMultiStates(curTimeInSec, lines);
            this.graphiteClient.send(lines.toString());
        }

        private void addStateValues(Long curTimeInSec, StringBuilder lines) {
            for (StateValueProvider stateValueProvider : StateValuesToGraphite.this.stateValues.values()) {
                try {
                    StringBuilder line = new StringBuilder();
                    line.append(this.keyPrefix).append(".").append(stateValueProvider.getName()).append(" ").append(stateValueProvider.getValue()).append(" ").append(curTimeInSec).append("\n");
                    lines.append(line.toString());
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("getting StateValue failed for " + stateValueProvider.getName()));
                }
            }
        }

        private void addMultiStates(Long curTimeInSec, StringBuilder lines) {
            for (MultiValueProvider multiValueProvider : StateValuesToGraphite.this.multiValueProviders.values()) {
                Collection<State> values = multiValueProvider.getValues();
                for (State state : values) {
                    StringBuilder line = new StringBuilder();
                    line.append(this.keyPrefix).append(".").append(multiValueProvider.getName()).append(".").append(state.name).append(" ").append(state.value).append(" ").append(curTimeInSec).append("\n");
                    lines.append(line.toString());
                }
            }
        }
    }
}

