/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.spring;

import de.is24.util.monitoring.InApplicationMonitor;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class MonitoringHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = Logger.getLogger(MonitoringHandlerInterceptor.class);
    private static final String PREFIX = "MonitoringHandlerInterceptor.";
    static final String START_TIME = "MonitoringHandlerInterceptor.startTime";
    static final String POST_HANDLE_TIME = "MonitoringHandlerInterceptor.postHandleTime";
    private static final String HANDLING = ".handling";
    private static final String RENDERING = ".rendering";
    private static final String COMPLETE = ".complete";
    private static final String ERROR = ".error";
    private static final String TIME_ERROR = ".timeError";
    private static final String DUPLICATE_HANDLER = ".duplicateHandler";
    private InApplicationMonitor monitor = InApplicationMonitor.getInstance();
    private static final Pattern CGLIB_PATTERN = Pattern.compile("[$]*EnhancerByCGLIB[0-9a-z$]*");

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (request.getAttribute(START_TIME) != null) {
            String prefix = this.getPrefix(handler);
            LOG.warn((Object)("Looks like MonitoringHandlerInterceptor is registered twice for request " + request.getRequestURI() + " Handler Info: " + prefix));
            this.monitor.incrementCounter(prefix + DUPLICATE_HANDLER);
        }
        request.setAttribute(START_TIME, (Object)System.currentTimeMillis());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        long currentTime = System.currentTimeMillis();
        long startTime = (Long)request.getAttribute(START_TIME);
        this.monitor.addTimerMeasurement(this.getPrefix(handler) + HANDLING, startTime, currentTime);
        request.setAttribute(POST_HANDLE_TIME, (Object)currentTime);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        long currentTime = System.currentTimeMillis();
        String measurementPrefix = this.getPrefix(handler);
        Object startTimeAttribute = this.getAndRemoveAttribute(request, START_TIME);
        Object postHandleObject = this.getAndRemoveAttribute(request, POST_HANDLE_TIME);
        if (startTimeAttribute == null) {
            LOG.info((Object)("Could not find start_time. Something went wrong with handler: " + measurementPrefix));
            this.monitor.incrementCounter(measurementPrefix + TIME_ERROR);
            return;
        }
        long startTime = (Long)startTimeAttribute;
        if (ex != null) {
            this.monitor.addTimerMeasurement(measurementPrefix + ERROR, startTime, currentTime);
        } else if (postHandleObject != null) {
            long postHandleTime = (Long)postHandleObject;
            this.monitor.addTimerMeasurement(measurementPrefix + RENDERING, postHandleTime, currentTime);
            this.monitor.addTimerMeasurement(measurementPrefix + COMPLETE, startTime, currentTime);
        }
    }

    private Object getAndRemoveAttribute(HttpServletRequest request, String attributeName) {
        Object attribute = request.getAttribute(attributeName);
        if (attribute != null) {
            request.removeAttribute(attributeName);
        }
        return attribute;
    }

    protected String getPrefix(Object handler) {
        String key;
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            key = PREFIX + handlerMethod.getBeanType().getName().replaceAll("\\.", "_") + "." + handlerMethod.getMethod().getName();
        } else {
            key = PREFIX + handler.getClass().getName();
        }
        key = CGLIB_PATTERN.matcher(key).replaceAll("EnhancerByCGLIB_IdStripped");
        return key;
    }
}

