/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.spring;

import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.visitors.AbstractSortedReportVisitor;
import de.is24.util.monitoring.visitors.HierarchyReportVisitor;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class Appmon4jDumper
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger LOGGER = Logger.getLogger(Appmon4jDumper.class);
    private final InApplicationMonitor inApplicationMonitor;

    public Appmon4jDumper(InApplicationMonitor inApplicationMonitor) {
        this.inApplicationMonitor = inApplicationMonitor;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        if (LOGGER.isInfoEnabled()) {
            HierarchyReportVisitor reportVisitor = new HierarchyReportVisitor();
            this.inApplicationMonitor.getCorePlugin().reportInto(reportVisitor);
            LOGGER.info((Object)("Dumping InApplicationMonitor content on ContextClosedEvent:\n" + this.dumpReporting(reportVisitor)));
        }
    }

    private String dumpReporting(HierarchyReportVisitor hierarchyReportVisitor) {
        StringBuilder builder = new StringBuilder(4096);
        for (HierarchyReportVisitor.Tree.TreeNode element : hierarchyReportVisitor.getTree().getAllNodesWithEntries()) {
            for (AbstractSortedReportVisitor.Entry entry : element.entries()) {
                builder.append(entry.getValue()).append("\n");
            }
        }
        this.removeNewLineCharacterAtTheEnd(builder);
        return builder.toString();
    }

    private void removeNewLineCharacterAtTheEnd(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
    }
}

