/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.CorePlugin;
import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.MonitorPlugin;
import de.is24.util.monitoring.keyhandler.DefaultKeyEscaper;
import de.is24.util.monitoring.keyhandler.KeyHandler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class TestingInApplicationMonitor
extends InApplicationMonitor {
    private static final Logger LOGGER = Logger.getLogger(TestingInApplicationMonitor.class);
    private static final ThreadLocal<CorePlugin> threadLocalCorePlugin = new InheritableThreadLocal<CorePlugin>();
    private static final ThreadLocal<List<MonitorPlugin>> threadLocalPluginsList = new InheritableThreadLocal<List<MonitorPlugin>>();

    public TestingInApplicationMonitor(CorePlugin corePlugin, KeyHandler keyHandler) {
        super(corePlugin, keyHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InApplicationMonitor initInstanceForTesting(CorePlugin corePlugin, KeyHandler keyHandler) {
        Object object = semaphore;
        synchronized (object) {
            if (INSTANCE != null) {
                INSTANCE.getCorePlugin().destroy();
            }
            LOGGER.info((Object)"+++ Changing InApplicationMonitor() for Testing only +++");
            INSTANCE = new TestingInApplicationMonitor(corePlugin, keyHandler);
            LOGGER.info((Object)"InApplicationMonitor changed successfully.");
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetInstanceForTesting() {
        Object object = semaphore;
        synchronized (object) {
            if (INSTANCE != null) {
                INSTANCE.getCorePlugin().destroy();
            }
            DefaultKeyEscaper keyHandler = new DefaultKeyEscaper();
            CorePlugin corePlugin = new CorePlugin(null, keyHandler);
            INSTANCE = new TestingInApplicationMonitor(corePlugin, keyHandler);
            LOGGER.info((Object)"Reset InApplicationMonitor for Testing.");
        }
    }

    @Override
    public CorePlugin getCorePlugin() {
        CorePlugin result = threadLocalCorePlugin.get();
        if (result == null) {
            result = super.getCorePlugin();
        }
        return result;
    }

    @Override
    public List<MonitorPlugin> getPlugins() {
        List<MonitorPlugin> result = threadLocalPluginsList.get();
        if (result == null) {
            result = super.getPlugins();
        }
        return result;
    }

    @Override
    public void setThreadLocalState() {
        CorePlugin corePlugin = new CorePlugin(null, this.getKeyHandler());
        threadLocalCorePlugin.set(corePlugin);
        CopyOnWriteArrayList<CorePlugin> monitorPlugins = new CopyOnWriteArrayList<CorePlugin>();
        monitorPlugins.add(corePlugin);
        threadLocalPluginsList.set(monitorPlugins);
    }

    @Override
    public void resetThreadLocalState() {
        threadLocalCorePlugin.remove();
        threadLocalPluginsList.remove();
    }
}

