/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.visitors;

import de.is24.util.monitoring.Counter;
import de.is24.util.monitoring.Historizable;
import de.is24.util.monitoring.HistorizableList;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Timer;
import de.is24.util.monitoring.Version;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public abstract class UnsortedWriterReportVisitor
implements ReportVisitor {
    private static final Logger LOGGER = Logger.getLogger(UnsortedWriterReportVisitor.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    protected Writer writer;

    public UnsortedWriterReportVisitor(Writer writer) {
        this.writer = writer;
    }

    protected void writeStringToWriter(String toWrite) {
        try {
            this.writer.write(toWrite);
            this.writer.write("\n");
        }
        catch (IOException e) {
            LOGGER.error((Object)"hoppla", (Throwable)e);
        }
    }

    @Override
    public void reportCounter(Counter counter) {
        LOGGER.debug((Object)"+++ entering UnsortedWriterReportVisitor.reportCounter +++");
        String result = counter.getName() + " counter :" + counter.getCount();
        this.writeStringToWriter(result);
    }

    @Override
    public void reportTimer(Timer timer) {
        LOGGER.debug((Object)"+++ entering UnsortedWriterReportVisitor.reportTimer +++");
        long count = timer.getCount();
        long timersum = timer.getTimerSum();
        String result = timer.getName() + " timer : count = " + count + ", timerSum = " + timersum + ", mean = " + (double)timersum / (double)count;
        this.writeStringToWriter(result);
    }

    @Override
    public void reportStateValue(StateValueProvider stateValueProvider) {
        LOGGER.debug((Object)"+++ entering UnsortedWriterReportVisitor.reportStateValue +++");
        String result = stateValueProvider.getName() + " state : " + stateValueProvider.getValue();
        this.writeStringToWriter(result);
    }

    @Override
    public void reportVersion(Version aVersion) {
        LOGGER.debug((Object)"+++ enter UnsortedWriterReportVisitor.reportVersion+++");
        String result = aVersion.getName() + " version : " + aVersion.getValue();
        this.writeStringToWriter(result);
    }

    @Override
    public void reportHistorizableList(HistorizableList aHistorizableList) {
        LOGGER.debug((Object)"+++ entering UnsortedWriterReportVisitor.reportHistorizableList +++");
        StringBuffer result = new StringBuffer();
        result.append(aHistorizableList.getName()).append(" historizable :\n");
        for (Historizable historizable : aHistorizableList) {
            result.append(DATE_FORMAT.format(historizable.getTimestamp())).append(" ");
            result.append(historizable.getValue()).append("\n");
        }
        this.writeStringToWriter(result.toString());
    }
}

