/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.statsd;

import de.is24.util.monitoring.AbstractMonitorPlugin;
import de.is24.util.monitoring.statsd.StatsdClient;
import java.net.SocketException;
import java.net.UnknownHostException;

public class StatsdPlugin
extends AbstractMonitorPlugin {
    private final StatsdClient delegate;
    private final String uniqueName;
    private double sampleRate;
    private double highVolumeSampleRate;

    public StatsdPlugin(String host, int port, String appName) throws UnknownHostException, SocketException {
        this(host, port, appName, 1.0);
    }

    public StatsdPlugin(String host, int port, String appName, double sampleRate) throws UnknownHostException, SocketException {
        this(new StatsdClient(host, port, appName), "StatsdPlugin_" + host + "_" + port + "_" + sampleRate);
        if (sampleRate < 0.0) {
            throw new IllegalArgumentException("negative sample rate not permitted");
        }
        this.sampleRate = sampleRate;
        this.initHighVolumeSampleRate();
    }

    StatsdPlugin(StatsdClient client, String uniqeName) {
        this.delegate = client;
        this.uniqueName = uniqeName;
        this.sampleRate = 1.0;
        this.initHighVolumeSampleRate();
    }

    @Override
    public void afterRemovalNotification() {
        this.delegate.close();
    }

    private void initHighVolumeSampleRate() {
        this.highVolumeSampleRate = this.sampleRate * 0.1;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    private String sanitizeKey(String key) {
        return key.replaceAll(":", "_");
    }

    @Override
    public void incrementCounter(String key, int increment) {
        this.delegate.increment(this.sanitizeKey(key), increment, this.sampleRate);
    }

    @Override
    public void incrementHighRateCounter(String key, int increment) {
        this.delegate.increment(this.sanitizeKey(key), increment, this.highVolumeSampleRate);
    }

    @Override
    public void initializeCounter(String name) {
    }

    @Override
    public void addTimerMeasurement(String key, long timing) {
        this.delegate.timing(this.sanitizeKey(key), (int)timing, this.sampleRate);
    }

    @Override
    public void addSingleEventTimerMeasurement(String name, long timing) {
    }

    @Override
    public void initializeTimerMeasurement(String name) {
    }

    @Override
    public void addHighRateTimerMeasurement(String key, long timing) {
        this.delegate.timing(this.sanitizeKey(key), (int)timing, this.highVolumeSampleRate);
    }
}

