/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.state2graphite;

import de.is24.util.monitoring.tools.ConnectionState;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import org.apache.log4j.Logger;

public class GraphiteConnection {
    private final Logger LOGGER = Logger.getLogger(GraphiteConnection.class);
    private final String graphiteHost;
    private final int graphitePort;
    private ConnectionState connectionState = ConnectionState.UNKNOWN;
    private long lastReportTimestamp = 0L;
    private static long connectionFailureLogDelay = 600000L;

    public GraphiteConnection(String graphiteHost, int graphitePort) {
        this.graphiteHost = graphiteHost;
        this.graphitePort = graphitePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String msg) {
        try {
            Socket socket = new Socket(this.graphiteHost, this.graphitePort);
            try {
                OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream());
                try {
                    writer.write(msg);
                    ((Writer)writer).flush();
                }
                finally {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException ioe) {
                        this.LOGGER.info((Object)"could not close writer");
                    }
                }
                if (this.connectionState != ConnectionState.SUCCESS) {
                    this.LOGGER.info((Object)("Connection to graphite Host " + (this.connectionState == ConnectionState.UNKNOWN ? "established" : "recovered")));
                    this.connectionState = ConnectionState.SUCCESS;
                }
            }
            catch (IOException e) {
                String action = "write";
                this.handleException(e, action);
            }
            finally {
                socket.close();
            }
        }
        catch (IOException e) {
            String action = "connect";
            this.handleException(e, action);
        }
    }

    private void handleException(IOException e, String action) {
        if (this.connectionState != ConnectionState.FAILED) {
            this.connectionState = ConnectionState.FAILED;
            this.LOGGER.warn((Object)("could not " + action + " to graphite host " + this.graphiteHost + " on port " + this.graphitePort), (Throwable)e);
            this.lastReportTimestamp = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastReportTimestamp > connectionFailureLogDelay) {
            this.LOGGER.warn((Object)("could not " + action + " to graphite host " + this.graphiteHost + " on port " + this.graphitePort), (Throwable)e);
            this.lastReportTimestamp = System.currentTimeMillis();
        }
    }
}

