/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.measurement.MeasurementHandler;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class PerfTimer {
    public static PerfTimer createTimer() {
        return PerfTimer.create(true);
    }

    public static PerfMonitor createMonitor() {
        return PerfMonitor.create();
    }

    public static PerfTimer createDebugTimer(Class<?> type) {
        return PerfTimer.create(type, Level.DEBUG);
    }

    public static PerfTimer createInfoTimer(Class<?> type) {
        return PerfTimer.create(type, Level.INFO);
    }

    public static PerfTimer create(Class<?> type, Level level) {
        boolean active = PerfTimer.isActive(type, level);
        return PerfTimer.create(active);
    }

    private static boolean isActive(Class<?> type, Level level) {
        return type == null || level == null || Logger.getLogger(type).isEnabledFor((Priority)level);
    }

    private static PerfTimer create(boolean active) {
        if (active) {
            return DefaultPerfTimer.create();
        }
        return NoPerfTimer.create();
    }

    public abstract long measure();

    public static final class PerfMonitor
    extends DefaultPerfTimer {
        static PerfMonitor create() {
            return new PerfMonitor();
        }

        protected PerfMonitor() {
        }

        @Deprecated
        public void monitor(String ... monitorNames) {
            assert (monitorNames != null && monitorNames.length > 0);
            long time = this.measure();
            for (String monitor : monitorNames) {
                assert (monitor != null && monitor.trim().length() > 0);
                InApplicationMonitor.getInstance().addTimerMeasurement(monitor, time);
            }
        }

        public void handleMeasurement(String monitorName, MeasurementHandler ... handlers) {
            long time = this.measure();
            for (MeasurementHandler handler : handlers) {
                handler.handle(monitorName, time);
            }
        }
    }

    private static class DefaultPerfTimer
    extends PerfTimer {
        protected final long start = System.currentTimeMillis();

        static PerfTimer create() {
            return new DefaultPerfTimer();
        }

        protected DefaultPerfTimer() {
        }

        @Override
        public long measure() {
            return System.currentTimeMillis() - this.start;
        }
    }

    private static final class NoPerfTimer
    extends PerfTimer {
        private static final PerfTimer INSTANCE = new NoPerfTimer();

        static PerfTimer create() {
            return INSTANCE;
        }

        private NoPerfTimer() {
        }

        @Override
        public long measure() {
            return 0L;
        }
    }
}

