/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.Reportable;
import de.is24.util.monitoring.ReportableObserver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class Monitors<T extends Reportable> {
    private final Map<String, T> monitors = new ConcurrentHashMap<String, T>();
    private final List<ReportableObserver> reportableObservers;

    public Monitors(List<ReportableObserver> reportableObservers) {
        this.reportableObservers = reportableObservers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String key, Factory<T> factory) {
        Object result = this.get(key);
        if (result == null) {
            Map<String, T> map = this.monitors;
            synchronized (map) {
                result = this.get(key);
                if (result == null) {
                    result = (Reportable)factory.createMonitor();
                    this.put(key, result);
                    this.notifyReportableObservers((Reportable)result);
                }
            }
        }
        return result;
    }

    public T get(String key) {
        return (T)((Reportable)this.monitors.get(key));
    }

    public T put(String key, T reportable) {
        return (T)((Reportable)this.monitors.put(key, reportable));
    }

    private void notifyReportableObservers(Reportable reportable) {
        for (ReportableObserver reportableObserver : this.reportableObservers) {
            reportableObserver.addNewReportable(reportable);
        }
    }

    public void accept(ReportVisitor reportVisitor) {
        for (Reportable reportable : this.getMonitors()) {
            reportable.accept(reportVisitor);
        }
    }

    public Collection<T> getMonitors() {
        return this.monitors.values();
    }

    public static interface Factory<T> {
        public T createMonitor();
    }
}

