/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.Historizable;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.Reportable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class HistorizableList
implements Reportable,
Iterable<Historizable> {
    private static final long serialVersionUID = -3419108076548380477L;
    private String name;
    private final int fMaxEntriesToKeep;
    private LinkedList<Historizable> historizables = new LinkedList();
    private static final Logger LOGGER = Logger.getLogger(HistorizableList.class);

    HistorizableList(String name, int aMaxEntriesToKeep) {
        this.name = name;
        this.fMaxEntriesToKeep = aMaxEntriesToKeep;
    }

    @Override
    public synchronized void accept(ReportVisitor aVisitor) {
        LOGGER.debug((Object)"+++ entering HistorizableList.accept +++");
        aVisitor.reportHistorizableList(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Historizable historizable) {
        LOGGER.debug((Object)"+++ entering HistorizableList.add +++");
        LinkedList<Historizable> linkedList = this.historizables;
        synchronized (linkedList) {
            if (this.historizables.size() >= this.fMaxEntriesToKeep) {
                this.historizables.removeLast();
            }
            this.historizables.addFirst(historizable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Historizable> iterator() {
        LinkedList<Historizable> linkedList = this.historizables;
        synchronized (linkedList) {
            return ((LinkedList)this.historizables.clone()).iterator();
        }
    }

    public int getMaxEntriesToKeep() {
        return this.fMaxEntriesToKeep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<Historizable> linkedList = this.historizables;
        synchronized (linkedList) {
            return this.historizables.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Historizable get(int index) {
        LinkedList<Historizable> linkedList = this.historizables;
        synchronized (linkedList) {
            return this.historizables.get(index);
        }
    }
}

