/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;

public class VirtualMachineMBeans {
    private static final int MAX_STACK_TRACE_DEPTH = 100;
    private static final VirtualMachineMBeans INSTANCE = new VirtualMachineMBeans(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans(), ManagementFactory.getOperatingSystemMXBean(), ManagementFactory.getThreadMXBean(), ManagementFactory.getGarbageCollectorMXBeans(), ManagementFactory.getRuntimeMXBean(), ManagementFactory.getPlatformMBeanServer());
    private final MemoryMXBean memory;
    private final List<MemoryPoolMXBean> memoryPools;
    private final OperatingSystemMXBean os;
    private final ThreadMXBean threads;
    private final List<GarbageCollectorMXBean> garbageCollectors;
    private final RuntimeMXBean runtime;
    private final MBeanServer mBeanServer;

    public static VirtualMachineMBeans getInstance() {
        return INSTANCE;
    }

    VirtualMachineMBeans(MemoryMXBean memory, List<MemoryPoolMXBean> memoryPools, OperatingSystemMXBean os, ThreadMXBean threads, List<GarbageCollectorMXBean> garbageCollectors, RuntimeMXBean runtime, MBeanServer mBeanServer) {
        this.memory = memory;
        this.memoryPools = memoryPools;
        this.os = os;
        this.threads = threads;
        this.garbageCollectors = garbageCollectors;
        this.runtime = runtime;
        this.mBeanServer = mBeanServer;
    }

    public MemoryMXBean getMemory() {
        return this.memory;
    }

    public List<MemoryPoolMXBean> getMemoryPools() {
        return this.memoryPools;
    }

    public OperatingSystemMXBean getOs() {
        return this.os;
    }

    public ThreadMXBean getThreads() {
        return this.threads;
    }

    public List<GarbageCollectorMXBean> getGarbageCollectors() {
        return this.garbageCollectors;
    }

    public RuntimeMXBean getRuntime() {
        return this.runtime;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public String getVersion() {
        return System.getProperty("java.runtime.version");
    }

    public String getName() {
        return System.getProperty("java.vm.name");
    }

    public Set<String> getDeadlockedThreads() {
        long[] threadIds = this.threads.findDeadlockedThreads();
        if (threadIds != null) {
            HashSet<String> threads = new HashSet<String>();
            for (ThreadInfo info : this.threads.getThreadInfo(threadIds, 100)) {
                StringBuilder stackTrace = new StringBuilder();
                for (StackTraceElement element : info.getStackTrace()) {
                    stackTrace.append("\t at ").append(element.toString()).append('\n');
                }
                threads.add(String.format("%s locked on %s (owned by %s):\n%s", info.getThreadName(), info.getLockName(), info.getLockOwnerName(), stackTrace.toString()));
            }
            return Collections.unmodifiableSet(threads);
        }
        return Collections.emptySet();
    }

    public void getThreadDump(OutputStream out) {
        ThreadInfo[] threads = this.threads.dumpAllThreads(true, true);
        PrintWriter writer = new PrintWriter(out, true);
        for (int ti = threads.length - 1; ti >= 0; --ti) {
            ThreadInfo t = threads[ti];
            writer.printf("%s id=%d state=%s", new Object[]{t.getThreadName(), t.getThreadId(), t.getThreadState()});
            LockInfo lock = t.getLockInfo();
            if (lock != null && t.getThreadState() != Thread.State.BLOCKED) {
                writer.printf("\n    - waiting on <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
                writer.printf("\n    - locked <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
            } else if (lock != null && t.getThreadState() == Thread.State.BLOCKED) {
                writer.printf("\n    - waiting to lock <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
            }
            if (t.isSuspended()) {
                writer.print(" (suspended)");
            }
            if (t.isInNative()) {
                writer.print(" (running in native)");
            }
            writer.println();
            if (t.getLockOwnerName() != null) {
                writer.printf("     owned by %s id=%d\n", t.getLockOwnerName(), t.getLockOwnerId());
            }
            StackTraceElement[] elements = t.getStackTrace();
            MonitorInfo[] monitors = t.getLockedMonitors();
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement element = elements[i];
                writer.printf("    at %s\n", element);
                for (int j = 1; j < monitors.length; ++j) {
                    MonitorInfo monitor = monitors[j];
                    if (monitor.getLockedStackDepth() != i) continue;
                    writer.printf("      - locked %s\n", monitor);
                }
            }
            writer.println();
            LockInfo[] locks = t.getLockedSynchronizers();
            if (locks.length <= 0) continue;
            writer.printf("    Locked synchronizers: count = %d\n", locks.length);
            for (LockInfo l : locks) {
                writer.printf("      - %s\n", l);
            }
            writer.println();
        }
        writer.println();
        writer.flush();
    }
}

