/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.Counter;
import de.is24.util.monitoring.Math;
import de.is24.util.monitoring.ReportVisitor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class Timer
extends Counter {
    private static final Logger LOGGER = Logger.getLogger(Timer.class);
    private final AtomicLong timerSum = new AtomicLong();
    private final AtomicLong timerSumOfSquares = new AtomicLong();

    Timer(String name) {
        super(name);
    }

    @Override
    public void accept(ReportVisitor aVisitor) {
        LOGGER.debug((Object)"+++ entering Timer.accept +++");
        aVisitor.reportTimer(this);
    }

    public void addMeasurement(long durationInMillis) {
        this.increment();
        this.timerSum.addAndGet(durationInMillis);
        this.timerSumOfSquares.addAndGet(durationInMillis * durationInMillis);
    }

    public void initializeMeasurement() {
        this.initialize();
        this.timerSum.set(0L);
        this.timerSumOfSquares.set(0L);
    }

    public long getTimerSum() {
        return this.timerSum.get();
    }

    public double getTimerAvg() {
        return Math.average(this.getCount(), this.timerSum.get());
    }

    public double getTimerStdDev() {
        return Math.stdDeviation(this.getCount(), this.timerSum.get(), this.timerSumOfSquares.get());
    }
}

