/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.CorePlugin;
import de.is24.util.monitoring.Historizable;
import de.is24.util.monitoring.MonitorPlugin;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.ReportableObserver;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Version;
import de.is24.util.monitoring.jmx.SimpleJmxAppmon4jNamingStrategy;
import de.is24.util.monitoring.keyhandler.DefaultKeyEscaper;
import de.is24.util.monitoring.keyhandler.KeyHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public final class InApplicationMonitor {
    private static final Logger LOGGER = Logger.getLogger(InApplicationMonitor.class);
    private static InApplicationMonitor INSTANCE;
    private volatile boolean monitorActive = true;
    private final CopyOnWriteArrayList<MonitorPlugin> plugins = new CopyOnWriteArrayList();
    private CorePlugin corePlugin;
    private KeyHandler keyHandler;

    protected InApplicationMonitor(CorePlugin corePlugin, KeyHandler keyHandler) {
        this.corePlugin = corePlugin;
        this.registerPlugin(corePlugin);
        this.keyHandler = keyHandler;
    }

    protected static InApplicationMonitor initInstanceForTesting(CorePlugin corePlugin, KeyHandler keyHandler) {
        LOGGER.info((Object)"+++ Changing InApplicationMonitor() for Testing only +++");
        INSTANCE = new InApplicationMonitor(corePlugin, keyHandler);
        LOGGER.info((Object)"InApplicationMonitor changed successfully.");
        return INSTANCE;
    }

    protected static void resetInstanceForTesting() {
        INSTANCE.getCorePlugin().destroy();
        INSTANCE = null;
        LOGGER.info((Object)"Reset InApplicationMonitor for Testing.");
    }

    public static InApplicationMonitor getInstance() {
        if (INSTANCE == null) {
            LOGGER.info((Object)"Initializing default InApplicationMonitor behavior. Use initInstance to customize");
            DefaultKeyEscaper keyHandler = new DefaultKeyEscaper();
            InApplicationMonitor.initInstance(new CorePlugin(new SimpleJmxAppmon4jNamingStrategy("is24"), keyHandler), keyHandler);
        }
        return INSTANCE;
    }

    public static InApplicationMonitor initInstance(CorePlugin corePlugin, KeyHandler keyHandler) {
        LOGGER.info((Object)"+++ initializing InApplicationMonitor() +++");
        if (INSTANCE != null) {
            LOGGER.warn((Object)"InApplicationMonitor already initialized on a call to initInstance, will create a new Instance. Observers registered up to this point will be discarded!");
            if (INSTANCE.getCorePlugin() != corePlugin) {
                INSTANCE.getCorePlugin().destroy();
            }
        }
        INSTANCE = new InApplicationMonitor(corePlugin, keyHandler);
        LOGGER.info((Object)"InApplicationMonitor initialized successfully.");
        return INSTANCE;
    }

    public void activate() {
        this.monitorActive = true;
    }

    public void deactivate() {
        this.monitorActive = false;
    }

    public boolean isMonitorActive() {
        return this.monitorActive;
    }

    @Deprecated
    public int getMaxHistoryEntriesToKeep() {
        return this.corePlugin.getMaxHistoryEntriesToKeep();
    }

    @Deprecated
    public void setMaxHistoryEntriesToKeep(int aMaxHistoryEntriesToKeep) {
        this.corePlugin.setMaxHistoryEntriesToKeep(aMaxHistoryEntriesToKeep);
    }

    public void addReportableObserver(ReportableObserver reportableObserver) {
        this.corePlugin.addReportableObserver(reportableObserver);
    }

    public void removeReportableObserver(ReportableObserver reportableObserver) {
        this.corePlugin.removeReportableObserver(reportableObserver);
    }

    public void reportInto(ReportVisitor reportVisitor) {
        this.corePlugin.reportInto(reportVisitor);
    }

    public void incrementCounter(String name) {
        this.incrementCounter(name, 1);
    }

    public void incrementHighRateCounter(String name) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.plugins) {
                p.incrementHighRateCounter(escapedName, 1);
            }
        }
    }

    public void incrementCounter(String name, int increment) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.plugins) {
                p.incrementCounter(escapedName, increment);
            }
        }
    }

    public void initializeCounter(String name) {
        String escapedName = this.keyHandler.handle(name);
        for (MonitorPlugin p : this.plugins) {
            p.initializeCounter(escapedName);
        }
    }

    public void addTimerMeasurement(String name, long timing) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.plugins) {
                p.addTimerMeasurement(escapedName, timing);
            }
        }
    }

    public void addSingleEventTimerMeasurement(String name, long timing) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.plugins) {
                p.addSingleEventTimerMeasurement(escapedName, timing);
            }
        }
    }

    public void addHighRateTimerMeasurement(String name, long timing) {
        if (this.monitorActive) {
            String escapedName = this.keyHandler.handle(name);
            for (MonitorPlugin p : this.plugins) {
                p.addHighRateTimerMeasurement(escapedName, timing);
            }
        }
    }

    public void addTimerMeasurement(String name, long begin, long end) {
        this.addTimerMeasurement(name, end - begin);
    }

    public void initializeTimerMeasurement(String name) {
        String escapedName = this.keyHandler.handle(name);
        for (MonitorPlugin p : this.plugins) {
            p.initializeTimerMeasurement(escapedName);
        }
    }

    public void registerStateValue(StateValueProvider stateValueProvider) {
        this.corePlugin.registerStateValue(stateValueProvider);
    }

    public void registerVersion(String name, String version) {
        Version versionToAdd = new Version(this.keyHandler.handle(name), version);
        this.corePlugin.registerVersion(versionToAdd);
    }

    public void addHistorizable(Historizable historizable) {
        this.corePlugin.addHistorizable(this.keyHandler.handle(historizable.getName()), historizable);
    }

    public void registerPlugin(MonitorPlugin plugin) {
        this.plugins.addIfAbsent(plugin);
    }

    public List<String> getRegisteredPluginKeys() {
        ArrayList<String> installedPluginKeys = new ArrayList<String>();
        for (MonitorPlugin plugin : this.plugins) {
            installedPluginKeys.add(plugin.getUniqueName());
        }
        return installedPluginKeys;
    }

    public void removeAllPlugins() {
        this.plugins.clear();
        this.plugins.add(this.corePlugin);
    }

    public CorePlugin getCorePlugin() {
        return this.corePlugin;
    }
}

