/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.AbstractMonitorPlugin;
import de.is24.util.monitoring.Counter;
import de.is24.util.monitoring.Historizable;
import de.is24.util.monitoring.HistorizableList;
import de.is24.util.monitoring.Monitors;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.Reportable;
import de.is24.util.monitoring.ReportableObserver;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Timer;
import de.is24.util.monitoring.Version;
import de.is24.util.monitoring.jmx.InApplicationMonitorJMXConnector;
import de.is24.util.monitoring.jmx.JmxAppMon4JNamingStrategy;
import de.is24.util.monitoring.keyhandler.KeyHandler;
import de.is24.util.monitoring.keyhandler.TransparentKeyHandler;
import de.is24.util.monitoring.tools.VirtualMachineMetrics;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CorePlugin
extends AbstractMonitorPlugin {
    private static Logger LOGGER = Logger.getLogger(CorePlugin.class);
    protected volatile boolean monitorActive = true;
    private volatile int maxHistoryEntriesToKeep = 5;
    private final Vector<ReportableObserver> reportableObservers = new Vector();
    private final Monitors<Counter> countersTimers = new Monitors(this.reportableObservers);
    private final Monitors<StateValueProvider> stateValues = new Monitors(this.reportableObservers);
    private final Monitors<Version> versions = new Monitors(this.reportableObservers);
    private final Monitors<HistorizableList> historizableLists = new Monitors(this.reportableObservers);
    private InApplicationMonitorJMXConnector inApplicationMonitorJMXConnector;
    private KeyHandler keyHandler;

    public CorePlugin(JmxAppMon4JNamingStrategy jmxAppMon4JNamingStrategy, KeyHandler keyHandler) {
        this.keyHandler = keyHandler != null ? keyHandler : new TransparentKeyHandler();
        if (jmxAppMon4JNamingStrategy != null) {
            this.inApplicationMonitorJMXConnector = new InApplicationMonitorJMXConnector(this, jmxAppMon4JNamingStrategy);
        }
        this.initDefaultStateValues();
    }

    public void initDefaultStateValues() {
        this.registerStateValue(new StateValueProvider(){

            @Override
            public String getName() {
                return Runtime.class.getName() + ".totalMem";
            }

            @Override
            public long getValue() {
                return Runtime.getRuntime().totalMemory();
            }
        });
        this.registerStateValue(new StateValueProvider(){

            @Override
            public String getName() {
                return Runtime.class.getName() + ".freeMem";
            }

            @Override
            public long getValue() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        this.registerVersion(new Version(this.getClass().getName(), "$Id: 2c8dd5d21e9900fd4595910d0d1a22abdbda00ba $"));
        VirtualMachineMetrics.registerVMStates(this);
    }

    @Override
    public void afterRemovalNotification() {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.isJMXInitialized()) {
            this.inApplicationMonitorJMXConnector.shutdown();
            this.inApplicationMonitorJMXConnector = null;
        }
    }

    @Override
    public String getUniqueName() {
        return "CorePlugin";
    }

    public boolean isJMXInitialized() {
        return this.inApplicationMonitorJMXConnector != null;
    }

    public int getMaxHistoryEntriesToKeep() {
        return this.maxHistoryEntriesToKeep;
    }

    public void setMaxHistoryEntriesToKeep(int aMaxHistoryEntriesToKeep) {
        this.maxHistoryEntriesToKeep = aMaxHistoryEntriesToKeep;
    }

    public void addReportableObserver(final ReportableObserver reportableObserver) {
        this.reportableObservers.add(reportableObserver);
        LOGGER.info((Object)("registering new ReportableObserver (" + reportableObserver.getClass().getName() + ")"));
        this.reportInto(new ReportVisitor(){

            public void notifyReportableObserver(Reportable reportable) {
                reportableObserver.addNewReportable(reportable);
            }

            @Override
            public void reportCounter(Counter counter) {
                this.notifyReportableObserver(counter);
            }

            @Override
            public void reportTimer(Timer timer) {
                this.notifyReportableObserver(timer);
            }

            @Override
            public void reportStateValue(StateValueProvider stateValueProvider) {
                this.notifyReportableObserver(stateValueProvider);
            }

            @Override
            public void reportHistorizableList(HistorizableList historizableList) {
                this.notifyReportableObserver(historizableList);
            }

            @Override
            public void reportVersion(Version version) {
                this.notifyReportableObserver(version);
            }
        });
    }

    private void notifyReportableObservers(Reportable reportable) {
        for (ReportableObserver reportableObserver : this.reportableObservers) {
            reportableObserver.addNewReportable(reportable);
        }
    }

    public void removeReportableObserver(ReportableObserver reportableObserver) {
        this.reportableObservers.remove(reportableObserver);
    }

    public void reportInto(ReportVisitor reportVisitor) {
        this.countersTimers.accept(reportVisitor);
        this.stateValues.accept(reportVisitor);
        this.versions.accept(reportVisitor);
        this.historizableLists.accept(reportVisitor);
    }

    @Override
    public void incrementCounter(String name, int increment) {
        this.incrementInternalCounter(increment, name);
    }

    @Override
    public void incrementHighRateCounter(String name, int increment) {
        this.incrementInternalCounter(increment, name);
    }

    private void incrementInternalCounter(int increment, String name) {
        this.getCounter(name).increment(increment);
    }

    @Override
    public void initializeCounter(String name) {
        this.getCounter(name).initialize();
    }

    @Override
    public void addTimerMeasurement(String name, long timing) {
        this.getTimer(name).addMeasurement(timing);
    }

    @Override
    public void addSingleEventTimerMeasurement(String name, long timing) {
        this.addTimerMeasurement(name, timing);
    }

    @Override
    public void addHighRateTimerMeasurement(String name, long timing) {
        this.addTimerMeasurement(name, timing);
    }

    @Override
    public void initializeTimerMeasurement(String name) {
        this.getTimer(name).initializeMeasurement();
    }

    public void registerStateValue(StateValueProvider stateValueProvider) {
        String name = this.keyHandler.handle(stateValueProvider.getName());
        StateValueProvider oldProvider = this.stateValues.put(name, stateValueProvider);
        if (oldProvider != null) {
            LOGGER.warn((Object)("StateValueProvider [" + oldProvider + "] @" + stateValueProvider.getName() + " has been replaced by [" + stateValueProvider + "]!"));
        }
        this.notifyReportableObservers(stateValueProvider);
    }

    public void registerVersion(Version versionToAdd) {
        String versionName = this.keyHandler.handle(versionToAdd.getName());
        this.versions.put(versionName, versionToAdd);
        this.notifyReportableObservers(versionToAdd);
    }

    public void addHistorizable(String name, Historizable historizable) {
        HistorizableList listToAddTo = this.getHistorizableList(name);
        listToAddTo.add(historizable);
    }

    StateValueProvider getStateValue(String name) {
        return this.stateValues.get(name);
    }

    Counter getCounter(final String name) {
        return this.countersTimers.get("counter." + name, new Monitors.Factory<Counter>(){

            @Override
            public Counter createMonitor() {
                return new Counter(name);
            }
        });
    }

    Timer getTimer(final String name) {
        return (Timer)this.countersTimers.get("timer." + name, new Monitors.Factory<Counter>(){

            @Override
            public Counter createMonitor() {
                return new Timer(name);
            }
        });
    }

    HistorizableList getHistorizableList(final String name) {
        return this.historizableLists.get(name, new Monitors.Factory<HistorizableList>(){

            @Override
            public HistorizableList createMonitor() {
                return new HistorizableList(name, CorePlugin.this.maxHistoryEntriesToKeep);
            }
        });
    }
}

