/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.visitors;

import de.is24.util.monitoring.visitors.AbstractSortedReportVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class HierarchyReportVisitor
extends AbstractSortedReportVisitor {
    private static final Logger LOGGER = Logger.getLogger(HierarchyReportVisitor.class);
    private Tree tree;

    public HierarchyReportVisitor() {
        LOGGER.debug((Object)"+++ enter HierarchyReportVisitor.HierarchyReportVisitor +++");
        this.tree = new Tree();
    }

    @Override
    protected void addEntry(AbstractSortedReportVisitor.Entry entry) {
        this.tree.addEntry(entry);
    }

    public Tree getTree() {
        return this.tree;
    }

    @Override
    public String toString() {
        List list = this.tree.getAllNodesWithEntries();
        StringBuilder buffy = new StringBuilder();
        buffy.append(this.getClass().getName());
        buffy.append("\n");
        for (Tree.TreeNode element : list) {
            Iterator entryIterator = element.getEntries();
            while (entryIterator.hasNext()) {
                AbstractSortedReportVisitor.Entry entry = (AbstractSortedReportVisitor.Entry)entryIterator.next();
                buffy.append(entry.getValue());
                buffy.append("\n");
            }
        }
        return buffy.toString();
    }

    public static class Tree {
        private TreeNode root = new TreeNode("", "root");

        protected Tree() {
        }

        public TreeNode getRoot() {
            return this.root;
        }

        public void addEntry(AbstractSortedReportVisitor.Entry entry) {
            StringTokenizer toki = new StringTokenizer(entry.getPath(), ".");
            TreeNode currentNode = this.root;
            while (toki.hasMoreTokens()) {
                String key = toki.nextToken();
                currentNode = currentNode.getChild(key);
            }
            currentNode.addEntry(entry);
        }

        List getAllNodesWithEntries() {
            ArrayList list = new ArrayList();
            this.root.addAllNodesWithEntries(list);
            return list;
        }

        public static final class TreeNode {
            String name;
            String fqn;
            TreeMap children;
            TreeMap entries;

            private TreeNode(String fqn, String name) {
                this.fqn = fqn;
                this.name = name;
            }

            public TreeNode getChild(String childName) {
                TreeNode child = null;
                if (this.children != null) {
                    child = (TreeNode)this.children.get(childName);
                }
                if (child == null) {
                    child = new TreeNode(this.fqn + "." + childName, childName);
                    if (this.children == null) {
                        this.children = new TreeMap();
                    }
                    this.children.put(childName, child);
                }
                return child;
            }

            public void addEntry(AbstractSortedReportVisitor.Entry entry) {
                if (this.entries == null) {
                    this.entries = new TreeMap();
                }
                this.entries.put(entry.getKey(), entry);
            }

            public boolean hasEntries() {
                return this.entries != null && this.entries.size() > 0;
            }

            public Iterator getEntries() {
                return this.entries == null ? null : this.entries.values().iterator();
            }

            public boolean hasChildren() {
                return this.children != null && this.children.size() > 0;
            }

            public List addAllNodesWithEntries(List list) {
                if (this.hasEntries()) {
                    list.add(this);
                }
                if (this.hasChildren()) {
                    for (TreeNode treeNode : this.children.values()) {
                        treeNode.addAllNodesWithEntries(list);
                    }
                }
                return list;
            }
        }
    }
}

