/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.visitors;

import de.is24.util.monitoring.Counter;
import de.is24.util.monitoring.Historizable;
import de.is24.util.monitoring.HistorizableList;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Timer;
import de.is24.util.monitoring.Version;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public abstract class AbstractSortedReportVisitor
implements ReportVisitor {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    protected abstract void addEntry(Entry var1);

    @Override
    public void reportCounter(Counter counter) {
        this.addEntry(new CounterEntry(counter));
    }

    @Override
    public void reportTimer(Timer timer) {
        this.addEntry(new TimerEntry(timer));
    }

    @Override
    public void reportStateValue(StateValueProvider stateValueProvider) {
        this.addEntry(new StateValueEntry(stateValueProvider));
    }

    @Override
    public void reportVersion(Version aVersion) {
        this.addEntry(new VersionEntry(aVersion));
    }

    @Override
    public void reportHistorizableList(HistorizableList aHistorizableList) {
        this.addEntry(new HistorizableEntry(aHistorizableList));
    }

    public abstract String toString();

    public final class HistorizableSubEntry {
        private final Date fTimestamp;
        private final String fValue;

        public HistorizableSubEntry(Date aTimestamp, String aValue) {
            this.fTimestamp = aTimestamp;
            this.fValue = aValue;
        }

        public Date getTimestamp() {
            return this.fTimestamp;
        }

        public String getValue() {
            return this.fValue;
        }
    }

    public final class HistorizableEntry
    extends Entry {
        private ArrayList<HistorizableSubEntry> historyValues;

        private HistorizableEntry(HistorizableList historizableList) {
            super(historizableList.getName(), "Historizable");
            this.historyValues = new ArrayList();
            for (Historizable historizable : historizableList) {
                this.historyValues.add(new HistorizableSubEntry(historizable.getTimestamp(), historizable.getValue()));
            }
        }

        @Override
        public String getValue() {
            StringBuilder buffy = new StringBuilder();
            buffy.append(this.getPath()).append(" Historizable ").append(this.getName()).append(" :\n");
            for (HistorizableSubEntry element : this.historyValues) {
                buffy.append(DATE_FORMAT.format(element.getTimestamp())).append(" : ").append(element.getValue()).append("\n");
            }
            return buffy.toString();
        }
    }

    public final class VersionEntry
    extends Entry {
        private Version fVersion;

        private VersionEntry(Version aVersion) {
            super(aVersion.getName(), "Version");
            this.fVersion = aVersion;
        }

        @Override
        public String getValue() {
            return this.getPath() + " Version " + this.getName() + " : " + this.fVersion.getValue();
        }
    }

    public final class StateValueEntry
    extends Entry {
        private long stateValue;

        private StateValueEntry(StateValueProvider stateValueProvider) {
            super(stateValueProvider.getName(), "StateValue");
            this.stateValue = stateValueProvider.getValue();
        }

        @Override
        public String getValue() {
            return this.getPath() + " StateValue " + this.getName() + " : " + this.getStateValue();
        }

        public long getStateValue() {
            return this.stateValue;
        }
    }

    public final class CounterEntry
    extends Entry {
        private long count;

        private CounterEntry(Counter counter) {
            super(counter.getName(), "counter");
            this.count = counter.getCount();
        }

        @Override
        public String getValue() {
            return this.getPath() + " Counter " + this.getName() + " : " + this.getCount();
        }

        public long getCount() {
            return this.count;
        }
    }

    public final class TimerEntry
    extends Entry {
        private long count;
        private long sum;
        private double average;
        private double stdDev;

        private TimerEntry(Timer timer) {
            super(timer.getName(), "timer");
            this.count = timer.getCount();
            this.sum = timer.getTimerSum();
            this.average = timer.getTimerAvg();
            this.stdDev = timer.getTimerStdDev();
        }

        @Override
        public String getValue() {
            return this.getPath() + " Timer " + this.getName() + " : " + this.getCount() + " took " + this.getSum() + " avg. " + this.average + " stdDev. " + this.getStdDev();
        }

        public long getCount() {
            return this.count;
        }

        public long getSum() {
            return this.sum;
        }

        public double getAverage() {
            return this.average;
        }

        public double getStdDev() {
            return this.stdDev;
        }
    }

    public static abstract class Entry {
        String name;
        String path;
        String type;

        private Entry(String fqn, String type) {
            int index = fqn.lastIndexOf(".");
            if (index >= 0) {
                this.name = fqn.substring(index + 1);
                this.path = fqn.substring(0, index);
            } else {
                this.name = fqn;
                this.path = "";
            }
            this.type = type;
        }

        public abstract String getValue();

        public String getKey() {
            return this.name + "." + this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }
    }
}

