/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.state2graphite;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import org.apache.log4j.Logger;

public class GraphiteConnection {
    private final Logger LOGGER = Logger.getLogger(GraphiteConnection.class);
    private final String graphiteHost;
    private final int graphitePort;

    GraphiteConnection(String graphiteHost, int graphitePort) {
        this.graphiteHost = graphiteHost;
        this.graphitePort = graphitePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String msg) {
        try {
            Socket socket = new Socket(this.graphiteHost, this.graphitePort);
            try {
                OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream());
                try {
                    writer.write(msg);
                    ((Writer)writer).flush();
                }
                finally {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException ioe) {
                        this.LOGGER.info((Object)"could not close writer");
                    }
                }
            }
            catch (IOException e) {
                this.LOGGER.warn((Object)("could not write to graphite host " + this.graphiteHost + " on port " + this.graphitePort), (Throwable)e);
            }
            finally {
                socket.close();
            }
        }
        catch (IOException e) {
            this.LOGGER.warn((Object)("could not connect to graphite host " + this.graphiteHost + " on port " + this.graphitePort), (Throwable)e);
        }
    }
}

