/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.helper;

import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.StateValueProvider;

public class HistogramLikeValue {
    public static final String NAME_BIGGER_THAN = ".biggerThan";
    public static final String NAME_FACTOR = ".factor";
    public static final String NAME_CURRENT_MAX = ".currentMax";
    private String baseName;
    private String timerName;
    private String factorName;
    private long factor;
    private long maxLimit = Long.MAX_VALUE;
    private long currentMaxValue = 0L;
    private String maxValueName;
    private String maxLimitName;

    public HistogramLikeValue(String baseName, final long factor) {
        this.baseName = baseName;
        this.timerName = baseName + ".total";
        this.maxValueName = baseName + NAME_CURRENT_MAX;
        this.maxLimitName = baseName + ".maxLimit";
        this.factorName = baseName + NAME_FACTOR;
        this.factor = factor;
        InApplicationMonitor.getInstance().registerStateValue(new StateValueProvider(){

            @Override
            public String getName() {
                return HistogramLikeValue.this.maxValueName;
            }

            @Override
            public long getValue() {
                return HistogramLikeValue.this.currentMaxValue;
            }
        });
        InApplicationMonitor.getInstance().registerStateValue(new StateValueProvider(){

            @Override
            public String getName() {
                return HistogramLikeValue.this.maxLimitName;
            }

            @Override
            public long getValue() {
                return HistogramLikeValue.this.maxLimit;
            }
        });
        InApplicationMonitor.getInstance().registerStateValue(new StateValueProvider(){

            @Override
            public String getName() {
                return HistogramLikeValue.this.factorName;
            }

            @Override
            public long getValue() {
                return factor;
            }
        });
    }

    public HistogramLikeValue(String baseName, long factor, long maxLimit) {
        this(baseName, factor);
        this.maxLimit = maxLimit;
    }

    public String getBaseName() {
        return this.baseName;
    }

    private String getBinName(long value) {
        StringBuilder binName = new StringBuilder();
        binName.append(this.baseName);
        binName.append(NAME_BIGGER_THAN);
        binName.append(value * this.factor);
        return binName.toString();
    }

    public void addValue(long newValue) {
        InApplicationMonitor.getInstance().addTimerMeasurement(this.timerName, newValue);
        if (newValue > this.currentMaxValue) {
            this.currentMaxValue = newValue;
        }
        long binIndex = newValue > this.maxLimit ? this.maxLimit / this.factor : newValue / this.factor;
        String binName = this.getBinName(binIndex);
        InApplicationMonitor.getInstance().incrementCounter(binName);
    }
}

