/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.CorePlugin;
import de.is24.util.monitoring.Historizable;
import de.is24.util.monitoring.MonitorPlugin;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.ReportableObserver;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Version;
import de.is24.util.monitoring.tools.VirtualMachineMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class InApplicationMonitor {
    private static final Logger LOGGER = Logger.getLogger(InApplicationMonitor.class);
    private static final Pattern KEY_ESCAPE_PATTERN = Pattern.compile("[:=]");
    private static final InApplicationMonitor INSTANCE = new InApplicationMonitor();
    private volatile boolean monitorActive = true;
    private CorePlugin corePlugin;
    private final CopyOnWriteArrayList<MonitorPlugin> plugins = new CopyOnWriteArrayList();

    public static InApplicationMonitor getInstance() {
        return INSTANCE;
    }

    private InApplicationMonitor() {
        LOGGER.info((Object)"+++ InApplicationMonitor() +++");
        this.corePlugin = new CorePlugin();
        this.registerPlugin(this.corePlugin);
        this.registerStateValue(new StateValueProvider(){

            @Override
            public String getName() {
                return Runtime.class.getName() + ".totalMem";
            }

            @Override
            public long getValue() {
                return Runtime.getRuntime().totalMemory();
            }
        });
        this.registerStateValue(new StateValueProvider(){

            @Override
            public String getName() {
                return Runtime.class.getName() + ".freeMem";
            }

            @Override
            public long getValue() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        this.registerVersion(this.getClass().getName(), "$Id: InApplicationMonitor.java 401410 2013-02-05 17:26:07Z oschmitz $ $HeadURL: https://subversion.iscout.local/int/is24/common/appmon4j/trunk/src/main/java/de/is24/util/monitoring/InApplicationMonitor.java $");
        VirtualMachineMetrics.registerVMStates(this);
        LOGGER.info((Object)"InApplicationMonitor started successfully.");
    }

    private String escape(String name) {
        return KEY_ESCAPE_PATTERN.matcher(name).replaceAll("_");
    }

    public void activate() {
        this.monitorActive = true;
    }

    public void deactivate() {
        this.monitorActive = false;
    }

    public boolean isMonitorActive() {
        return this.monitorActive;
    }

    @Deprecated
    public int getMaxHistoryEntriesToKeep() {
        return this.corePlugin.getMaxHistoryEntriesToKeep();
    }

    @Deprecated
    public void setMaxHistoryEntriesToKeep(int aMaxHistoryEntriesToKeep) {
        this.corePlugin.setMaxHistoryEntriesToKeep(aMaxHistoryEntriesToKeep);
    }

    public void addReportableObserver(ReportableObserver reportableObserver) {
        this.corePlugin.addReportableObserver(reportableObserver);
    }

    public void removeReportableObserver(ReportableObserver reportableObserver) {
        this.corePlugin.removeReportableObserver(reportableObserver);
    }

    public void reportInto(ReportVisitor reportVisitor) {
        this.corePlugin.reportInto(reportVisitor);
    }

    public void incrementCounter(String name) {
        this.incrementCounter(name, 1);
    }

    public void incrementHighRateCounter(String name) {
        if (this.monitorActive) {
            String escapedName = this.escape(name);
            for (MonitorPlugin p : this.plugins) {
                p.incrementHighRateCounter(escapedName, 1);
            }
        }
    }

    public void incrementCounter(String name, int increment) {
        if (this.monitorActive) {
            String escapedName = this.escape(name);
            for (MonitorPlugin p : this.plugins) {
                p.incrementCounter(escapedName, increment);
            }
        }
    }

    public void initializeCounter(String name) {
        String escapedName = this.escape(name);
        for (MonitorPlugin p : this.plugins) {
            p.initializeCounter(escapedName);
        }
    }

    public void addTimerMeasurement(String name, long timing) {
        if (this.monitorActive) {
            String escapedName = this.escape(name);
            for (MonitorPlugin p : this.plugins) {
                p.addTimerMeasurement(escapedName, timing);
            }
        }
    }

    public void addSingleEventTimerMeasurement(String name, long timing) {
        if (this.monitorActive) {
            String escapedName = this.escape(name);
            for (MonitorPlugin p : this.plugins) {
                p.addSingleEventTimerMeasurement(escapedName, timing);
            }
        }
    }

    public void addHighRateTimerMeasurement(String name, long timing) {
        if (this.monitorActive) {
            String escapedName = this.escape(name);
            for (MonitorPlugin p : this.plugins) {
                p.addHighRateTimerMeasurement(escapedName, timing);
            }
        }
    }

    public void addTimerMeasurement(String name, long begin, long end) {
        this.addTimerMeasurement(name, end - begin);
    }

    public void initializeTimerMeasurement(String name) {
        String escapedName = this.escape(name);
        for (MonitorPlugin p : this.plugins) {
            p.initializeTimerMeasurement(escapedName);
        }
    }

    public void registerStateValue(StateValueProvider stateValueProvider) {
        this.corePlugin.registerStateValue(this.escape(stateValueProvider.getName()), stateValueProvider);
    }

    public void registerVersion(String name, String version) {
        Version versionToAdd = new Version(this.escape(name), version);
        this.corePlugin.registerVersion(versionToAdd);
    }

    public void addHistorizable(Historizable historizable) {
        this.corePlugin.addHistorizable(this.escape(historizable.getName()), historizable);
    }

    public void registerPlugin(MonitorPlugin plugin) {
        this.plugins.addIfAbsent(plugin);
    }

    public List<String> getRegisteredPluginKeys() {
        ArrayList<String> installedPluginKeys = new ArrayList<String>();
        for (MonitorPlugin plugin : this.plugins) {
            installedPluginKeys.add(plugin.getUniqueName());
        }
        return installedPluginKeys;
    }

    public void removeAllPlugins() {
        this.plugins.clear();
        this.plugins.add(this.corePlugin);
    }

    public CorePlugin getCorePlugin() {
        return this.corePlugin;
    }
}

