/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.visitors;

import de.is24.util.monitoring.Counter;
import de.is24.util.monitoring.HistorizableList;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Timer;
import de.is24.util.monitoring.Version;
import java.util.TreeMap;

public class HistogramLikeValueAnalysisVisitor
implements ReportVisitor {
    private String base;
    private float[] percentages = new float[]{0.8f, 0.9f, 0.95f, 0.99f, 1.0f};
    private long totalCount = 0L;
    private long factor = 0L;
    private TreeMap<Long, Long> timeToCount = new TreeMap();
    private long currentMax;

    public HistogramLikeValueAnalysisVisitor(String base) {
        this.base = base;
    }

    @Override
    public void reportCounter(Counter counter) {
        String baseName;
        String name = counter.getName();
        if (name.startsWith(baseName = this.base + ".biggerThan")) {
            String timeString = name.substring(baseName.length());
            long time = Long.parseLong(timeString);
            long count = counter.getCount();
            this.timeToCount.put(time, count);
            this.totalCount += count;
        }
    }

    @Override
    public void reportHistorizableList(HistorizableList historizableList) {
    }

    @Override
    public void reportStateValue(StateValueProvider stateValueProvider) {
        String baseNameFactor = this.base + ".factor";
        String baseNameCurrentMax = this.base + ".currentMax";
        if (stateValueProvider.getName().equals(baseNameFactor)) {
            this.factor = stateValueProvider.getValue();
        } else if (stateValueProvider.getName().equals(baseNameCurrentMax)) {
            this.currentMax = stateValueProvider.getValue();
        }
    }

    @Override
    public void reportTimer(Timer timer) {
    }

    @Override
    public void reportVersion(Version version) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int currentPercentageIdx = 0;
        long currentCount = 0L;
        sb.append(this.base).append("\n");
        for (Long time : this.timeToCount.keySet()) {
            float border;
            Long count = this.timeToCount.get(time);
            if (!((float)(currentCount += count.longValue()) >= (border = this.percentages[currentPercentageIdx] * (float)this.totalCount))) continue;
            double currentPercentage = (double)currentCount / (double)this.totalCount * 100.0;
            sb.append(currentCount).append(" values, which are ").append(currentPercentage).append("%, are smaller than ").append(currentPercentage >= 100.0 ? "or equal to " : "").append(currentPercentage >= 100.0 ? this.currentMax : time + this.factor).append(" flurbs").append("\n");
            ++currentPercentageIdx;
        }
        return sb.toString();
    }
}

