/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.state2graphite;

import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.Reportable;
import de.is24.util.monitoring.ReportableObserver;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.state2graphite.GraphiteConnection;
import de.is24.util.monitoring.tools.LocalHostNameResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class StateValuesToGraphite
implements ReportableObserver {
    private static final Logger LOGGER = Logger.getLogger(StateValuesToGraphite.class);
    private ScheduledExecutorService ex;
    private Map<String, StateValueProvider> stateValues;

    public StateValuesToGraphite(String graphiteHost, int graphitePort, String appName) {
        this(appName, new LocalHostNameResolver(), new GraphiteConnection(graphiteHost, graphitePort));
    }

    StateValuesToGraphite(String appName, LocalHostNameResolver localHostNameResolver, GraphiteConnection graphiteClient) {
        String keyPrefix = appName + "." + localHostNameResolver.getLocalHostName() + ".states";
        this.stateValues = new ConcurrentHashMap<String, StateValueProvider>();
        InApplicationMonitor.getInstance().addReportableObserver(this);
        this.ex = Executors.newSingleThreadScheduledExecutor();
        this.ex.scheduleAtFixedRate(new ReportStateValuesJob(graphiteClient, keyPrefix), 1L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void addNewReportable(Reportable reportable) {
        if (reportable instanceof StateValueProvider) {
            this.stateValues.put(reportable.getName(), (StateValueProvider)reportable);
        }
    }

    public void shutdown() {
        InApplicationMonitor.getInstance().removeReportableObserver(this);
        this.ex.shutdown();
    }

    private class ReportStateValuesJob
    implements Runnable {
        private final GraphiteConnection graphiteClient;
        private final String keyPrefix;

        public ReportStateValuesJob(GraphiteConnection graphiteClient, String keyPrefix) {
            this.graphiteClient = graphiteClient;
            this.keyPrefix = keyPrefix;
        }

        @Override
        public void run() {
            LOGGER.debug((Object)("writing " + StateValuesToGraphite.this.stateValues.size() + " state values to graphite"));
            Long curTimeInSec = System.currentTimeMillis() / 1000L;
            StringBuilder lines = new StringBuilder();
            for (StateValueProvider stateValueProvider : StateValuesToGraphite.this.stateValues.values()) {
                lines.append(this.keyPrefix).append(".").append(stateValueProvider.getName()).append(" ").append(stateValueProvider.getValue()).append(" ").append(curTimeInSec).append("\n");
            }
            this.graphiteClient.send(lines.toString());
        }
    }
}

