/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.jmx;

import de.is24.util.monitoring.HistorizableList;
import de.is24.util.monitoring.jmx.JmxReportable;
import java.util.ArrayList;
import javax.management.MBeanAttributeInfo;
import org.apache.log4j.Logger;

class HistorizableListJmxReportable
implements JmxReportable {
    private static final Logger LOGGER = Logger.getLogger(HistorizableListJmxReportable.class);
    private final HistorizableList reportable;

    public HistorizableListJmxReportable(HistorizableList reportable) {
        assert (reportable != null);
        this.reportable = reportable;
    }

    @Override
    public MBeanAttributeInfo[] getAttributes() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        for (int i = 1; i <= this.reportable.getMaxEntriesToKeep(); ++i) {
            attributes.add(new MBeanAttributeInfo(Integer.toString(i), "String", "Value number " + i + " in history", true, false, false));
        }
        return attributes.toArray(new MBeanAttributeInfo[attributes.size()]);
    }

    @Override
    public Object getAttribute(String attributeName) {
        try {
            int index = Integer.parseInt(attributeName) - 1;
            if (index < this.reportable.getMaxEntriesToKeep()) {
                return this.reportable.get(index).getValue();
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Should never happen! Requested attribute should be an integer but was: " + attributeName));
        }
        return null;
    }
}

