/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.tools;

import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteMockServer
extends ExternalResource
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GraphiteMockServer.class);
    private ServerSocketChannel server;
    private int port;
    private Selector selector;
    private Thread thread;

    public void before() throws Throwable {
        LOG.info("Graphite Mock before...");
        this.server = ServerSocketChannel.open();
        this.server.configureBlocking(false);
        this.port = Network.getFreeServerPort();
        LOG.info("GraphiteMockServer starting : port={}", (Object)this.port);
        this.server.socket().bind(new InetSocketAddress(this.port));
        this.selector = Selector.open();
        this.server.register(this.selector, 16);
        this.thread = new Thread(this);
        this.thread.start();
        LOG.info("... done Graphite Mock before");
    }

    public void after() {
        LOG.info("Graphite Mock after");
        try {
            this.thread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        Charset charset = Charset.forName("ISO-8859-1");
        CharsetDecoder decoder = charset.newDecoder();
        try {
            while (!this.thread.isInterrupted()) {
                this.selector.select();
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SocketChannel client;
                    SelectionKey key = iterator.next();
                    iterator.remove();
                    if (!key.isValid()) continue;
                    if (key.isAcceptable()) {
                        client = this.server.accept();
                        client.configureBlocking(false);
                        client.register(this.selector, 1);
                        continue;
                    }
                    if (!key.isReadable()) continue;
                    client = (SocketChannel)key.channel();
                    int BUFFER_SIZE = 1024;
                    ByteBuffer buffer = ByteBuffer.allocate(BUFFER_SIZE);
                    try {
                        int bytesRead = client.read(buffer);
                        if (bytesRead <= 0) continue;
                        buffer.flip();
                        CharBuffer charBuffer = decoder.decode(buffer);
                        LOG.info(charBuffer.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

