/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.tools;

import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsdMockServer
extends ExternalResource
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(StatsdMockServer.class);
    private ServerSocketChannel server;
    private int port;
    private Selector selector;
    private Thread thread;

    public void before() throws Throwable {
        this.server = ServerSocketChannel.open();
        this.server.configureBlocking(false);
        int maxTries = 3;
        int sleepInSec = 2;
        for (int i = 0; i < maxTries; ++i) {
            try {
                this.port = Network.getFreeServerPort();
                this.server.socket().bind(new InetSocketAddress(this.port));
                LOG.info("StatsdMockServer started : port={}", (Object)this.port);
                continue;
            }
            catch (Throwable e) {
                int lastTry = maxTries - 1;
                if (i < lastTry) {
                    LOG.warn(String.format("Starting StatsdMockServer: try %s of %s failed. Retry after %s seconds.", i + 1, maxTries, sleepInSec), e);
                    Thread.sleep(sleepInSec * 1000);
                    continue;
                }
                LOG.error(String.format("Starting StatsdMockServer: %s of %s failed. No retries left.", i + 1, maxTries));
                throw e;
            }
        }
        this.selector = Selector.open();
        this.server.register(this.selector, 16);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void after() {
        try {
            this.thread.interrupt();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.selector.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        try {
            while (!this.thread.isInterrupted()) {
                if (this.selector.select() <= 0) continue;
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SocketChannel client;
                    SelectionKey key = iterator.next();
                    iterator.remove();
                    if (!key.isValid()) continue;
                    if (key.isAcceptable()) {
                        client = this.server.accept();
                        client.configureBlocking(false);
                        client.register(this.selector, 1);
                        continue;
                    }
                    if (!key.isReadable()) continue;
                    client = (SocketChannel)key.channel();
                    int BUFFER_SIZE = 32;
                    ByteBuffer buffer = ByteBuffer.allocate(BUFFER_SIZE);
                    try {
                        client.read(buffer);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

