/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.spring;

import de.is24.util.monitoring.InApplicationMonitor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TimeMeasurementAspect {
    @Pointcut(value="@annotation(de.is24.util.monitoring.spring.TimeMeasurement)")
    private void timeMeasurementMethods() {
    }

    @Pointcut(value="@within(de.is24.util.monitoring.spring.TimeMeasurement)")
    private void timeMeasurementTypes() {
    }

    @Pointcut(value="execution(public * *(..))")
    private void publicMethods() {
    }

    @Pointcut(value="timeMeasurementTypes() && publicMethods()")
    private void publicMethodsInTimeMeasuredTypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="timeMeasurementMethods() || publicMethodsInTimeMeasuredTypes()")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) throws Throwable {
        long startTime = System.currentTimeMillis();
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            long endTime = System.currentTimeMillis();
            String name = pjp.getSignature().getDeclaringTypeName() + "." + pjp.getSignature().getName();
            InApplicationMonitor.getInstance().addTimerMeasurement(name, startTime, endTime);
        }
    }
}

