/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.hystrix;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import de.is24.util.monitoring.AbstractStateValueProvider;
import de.is24.util.monitoring.CorePlugin;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.tools.KeyHelper;

public class HystrixAppmon4jMetricsPublisherCommand
implements HystrixMetricsPublisherCommand {
    private final HystrixCommandKey key;
    private final HystrixCommandGroupKey commandGroupKey;
    private final HystrixCommandMetrics metrics;
    private final HystrixCircuitBreaker circuitBreaker;
    private final HystrixCommandProperties properties;
    private final String metricGroup;
    private final String metricType;
    private final CorePlugin corePlugin;

    public HystrixAppmon4jMetricsPublisherCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandGroupKey, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties, CorePlugin corePlugin) {
        this.key = commandKey;
        this.commandGroupKey = commandGroupKey;
        this.metrics = metrics;
        this.circuitBreaker = circuitBreaker;
        this.properties = properties;
        this.metricGroup = "HystrixCommand";
        this.metricType = this.key.name();
        this.corePlugin = corePlugin;
    }

    public void initialize() {
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("isCircuitBreakerOpen")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.circuitBreaker.isOpen() ? 1L : 0L;
            }
        });
        this.createCumulativeCountForEvent("countCollapsedRequests", HystrixRollingNumberEvent.COLLAPSED);
        this.createCumulativeCountForEvent("countExceptionsThrown", HystrixRollingNumberEvent.EXCEPTION_THROWN);
        this.createCumulativeCountForEvent("countFailure", HystrixRollingNumberEvent.FAILURE);
        this.createCumulativeCountForEvent("countFallbackFailure", HystrixRollingNumberEvent.FALLBACK_FAILURE);
        this.createCumulativeCountForEvent("countFallbackRejection", HystrixRollingNumberEvent.FALLBACK_REJECTION);
        this.createCumulativeCountForEvent("countFallbackSuccess", HystrixRollingNumberEvent.FALLBACK_SUCCESS);
        this.createCumulativeCountForEvent("countResponsesFromCache", HystrixRollingNumberEvent.RESPONSE_FROM_CACHE);
        this.createCumulativeCountForEvent("countSemaphoreRejected", HystrixRollingNumberEvent.SEMAPHORE_REJECTED);
        this.createCumulativeCountForEvent("countShortCircuited", HystrixRollingNumberEvent.SHORT_CIRCUITED);
        this.createCumulativeCountForEvent("countSuccess", HystrixRollingNumberEvent.SUCCESS);
        this.createCumulativeCountForEvent("countThreadPoolRejected", HystrixRollingNumberEvent.THREAD_POOL_REJECTED);
        this.createCumulativeCountForEvent("countTimeout", HystrixRollingNumberEvent.TIMEOUT);
        this.createRollingCountForEvent("rollingCountCollapsedRequests", HystrixRollingNumberEvent.COLLAPSED);
        this.createRollingCountForEvent("rollingCountExceptionsThrown", HystrixRollingNumberEvent.EXCEPTION_THROWN);
        this.createRollingCountForEvent("rollingCountFailure", HystrixRollingNumberEvent.FAILURE);
        this.createRollingCountForEvent("rollingCountFallbackFailure", HystrixRollingNumberEvent.FALLBACK_FAILURE);
        this.createRollingCountForEvent("rollingCountFallbackRejection", HystrixRollingNumberEvent.FALLBACK_REJECTION);
        this.createRollingCountForEvent("rollingCountFallbackSuccess", HystrixRollingNumberEvent.FALLBACK_SUCCESS);
        this.createRollingCountForEvent("rollingCountResponsesFromCache", HystrixRollingNumberEvent.RESPONSE_FROM_CACHE);
        this.createRollingCountForEvent("rollingCountSemaphoreRejected", HystrixRollingNumberEvent.SEMAPHORE_REJECTED);
        this.createRollingCountForEvent("rollingCountShortCircuited", HystrixRollingNumberEvent.SHORT_CIRCUITED);
        this.createRollingCountForEvent("rollingCountSuccess", HystrixRollingNumberEvent.SUCCESS);
        this.createRollingCountForEvent("rollingCountThreadPoolRejected", HystrixRollingNumberEvent.THREAD_POOL_REJECTED);
        this.createRollingCountForEvent("rollingCountTimeout", HystrixRollingNumberEvent.TIMEOUT);
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("executionSemaphorePermitsInUse")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getCurrentConcurrentExecutionCount();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("errorPercentage")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getHealthCounts().getErrorPercentage();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyExecute_mean")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getExecutionTimeMean();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyExecute_percentile_5")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(5.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyExecute_percentile_25")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(25.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyExecute_percentile_50")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(50.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyExecute_percentile_75")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(75.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyExecute_percentile_90")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(90.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyExecute_percentile_99")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(99.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyExecute_percentile_995")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(99.5);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyTotal_mean")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getTotalTimeMean();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyTotal_percentile_5")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getTotalTimePercentile(5.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyTotal_percentile_25")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getTotalTimePercentile(25.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyTotal_percentile_50")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getTotalTimePercentile(50.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyTotal_percentile_75")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getTotalTimePercentile(75.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyTotal_percentile_90")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getTotalTimePercentile(90.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyTotal_percentile_99")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getTotalTimePercentile(99.0);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("latencyTotal_percentile_995")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getTotalTimePercentile(99.5);
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_rollingStatisticalWindowInMilliseconds")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherCommand.this.properties.metricsRollingStatisticalWindowInMilliseconds().get()).intValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_circuitBreakerRequestVolumeThreshold")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherCommand.this.properties.circuitBreakerRequestVolumeThreshold().get()).intValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_circuitBreakerSleepWindowInMilliseconds")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherCommand.this.properties.circuitBreakerSleepWindowInMilliseconds().get()).intValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_circuitBreakerErrorThresholdPercentage")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherCommand.this.properties.circuitBreakerErrorThresholdPercentage().get()).intValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_circuitBreakerForceOpen")){

            public long getValue() {
                return (Boolean)HystrixAppmon4jMetricsPublisherCommand.this.properties.circuitBreakerForceOpen().get() != false ? 1L : 0L;
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_circuitBreakerForceClosed")){

            public long getValue() {
                return (Boolean)HystrixAppmon4jMetricsPublisherCommand.this.properties.circuitBreakerForceClosed().get() != false ? 1L : 0L;
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_executionIsolationThreadTimeoutInMilliseconds")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherCommand.this.properties.executionIsolationThreadTimeoutInMilliseconds().get()).intValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_requestCacheEnabled")){

            public long getValue() {
                return (Boolean)HystrixAppmon4jMetricsPublisherCommand.this.properties.requestCacheEnabled().get() != false ? 1L : 0L;
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_requestLogEnabled")){

            public long getValue() {
                return (Boolean)HystrixAppmon4jMetricsPublisherCommand.this.properties.requestLogEnabled().get() != false ? 1L : 0L;
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_executionIsolationSemaphoreMaxConcurrentRequests")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherCommand.this.properties.executionIsolationSemaphoreMaxConcurrentRequests().get()).intValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherCommand.this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests().get()).intValue();
            }
        });
    }

    protected String createMetricName(String name) {
        return KeyHelper.name((String)this.metricGroup, (String[])new String[]{this.metricType, name});
    }

    protected void createCumulativeCountForEvent(String name, final HystrixRollingNumberEvent event) {
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName(name)){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getCumulativeCount(event);
            }
        });
    }

    protected void createRollingCountForEvent(String name, final HystrixRollingNumberEvent event) {
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName(name)){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherCommand.this.metrics.getRollingCount(event);
            }
        });
    }
}

