/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherThreadPool;
import de.is24.util.monitoring.AbstractStateValueProvider;
import de.is24.util.monitoring.CorePlugin;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.tools.KeyHelper;

public class HystrixAppmon4jMetricsPublisherThreadPool
implements HystrixMetricsPublisherThreadPool {
    private final HystrixThreadPoolKey key;
    private final HystrixThreadPoolMetrics metrics;
    private final HystrixThreadPoolProperties properties;
    private final String metricGroup;
    private final String metricType;
    private final CorePlugin corePlugin;

    public HystrixAppmon4jMetricsPublisherThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties, CorePlugin corePlugin) {
        this.key = threadPoolKey;
        this.metrics = metrics;
        this.properties = properties;
        this.metricGroup = "HystrixThreadPool";
        this.metricType = this.key.name();
        this.corePlugin = corePlugin;
    }

    public void initialize() {
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("threadActiveCount")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherThreadPool.this.metrics.getCurrentActiveCount().longValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("completedTaskCount")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherThreadPool.this.metrics.getCurrentCompletedTaskCount().longValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("largestPoolSize")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherThreadPool.this.metrics.getCurrentLargestPoolSize().longValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("totalTaskCount")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherThreadPool.this.metrics.getCurrentTaskCount().longValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("queueSize")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherThreadPool.this.metrics.getCurrentQueueSize().longValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("rollingMaxActiveThreads")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherThreadPool.this.metrics.getRollingMaxActiveThreads();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("countThreadsExecuted")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherThreadPool.this.metrics.getCumulativeCountThreadsExecuted();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("rollingCountThreadsExecuted")){

            public long getValue() {
                return HystrixAppmon4jMetricsPublisherThreadPool.this.metrics.getRollingCountThreadsExecuted();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_corePoolSize")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherThreadPool.this.properties.coreSize().get()).intValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_keepAliveTimeInMinutes")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherThreadPool.this.properties.keepAliveTimeMinutes().get()).intValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_queueSizeRejectionThreshold")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherThreadPool.this.properties.queueSizeRejectionThreshold().get()).intValue();
            }
        });
        this.corePlugin.registerStateValue((StateValueProvider)new AbstractStateValueProvider(this.createMetricName("propertyValue_maxQueueSize")){

            public long getValue() {
                return ((Integer)HystrixAppmon4jMetricsPublisherThreadPool.this.properties.maxQueueSize().get()).intValue();
            }
        });
    }

    protected String createMetricName(String name) {
        return KeyHelper.name((String)this.metricGroup, (String[])new String[]{this.metricType, name});
    }
}

